/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.ThreadContext;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.windowing.WaterMarkEvent;
import org.apache.pulsar.functions.windowing.WindowManager;
import org.apache.pulsar.functions.windowing.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMarkEventGenerator<T>
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WaterMarkEventGenerator.class);
    private final WindowManager<T> windowManager;
    private final long eventTsLagMs;
    private final Set<String> inputTopics;
    private final Map<String, Long> topicToTs;
    private final ScheduledExecutorService executorService;
    private final long intervalMs;
    private ScheduledFuture<?> executorFuture;
    private volatile long lastWaterMarkTs;
    private Context context;

    public WaterMarkEventGenerator(WindowManager<T> windowManager, long intervalMs, long eventTsLagMs, Set<String> inputTopics, Context context) {
        this.windowManager = windowManager;
        this.topicToTs = new ConcurrentHashMap<String, Long>();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("watermark-event-generator-%d").setDaemon(true).build();
        this.executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.intervalMs = intervalMs;
        this.eventTsLagMs = eventTsLagMs;
        this.inputTopics = inputTopics;
        this.context = context;
    }

    public boolean track(String inputTopic, long ts) {
        Long currentVal = this.topicToTs.get(inputTopic);
        if (currentVal == null || ts > currentVal) {
            this.topicToTs.put(inputTopic, ts);
        }
        this.checkFailures();
        return ts >= this.lastWaterMarkTs;
    }

    @Override
    public void run() {
        ThreadContext.put((String)"function", (String)WindowUtils.getFullyQualifiedName(this.context.getTenant(), this.context.getNamespace(), this.context.getFunctionName()));
        try {
            long waterMarkTs = this.computeWaterMarkTs();
            if (waterMarkTs > this.lastWaterMarkTs) {
                this.windowManager.add(new WaterMarkEvent(waterMarkTs));
                this.lastWaterMarkTs = waterMarkTs;
            }
        }
        catch (Throwable th) {
            log.error("Failed while processing watermark event ", th);
            throw th;
        }
    }

    private long computeWaterMarkTs() {
        long ts = 0L;
        if (this.topicToTs.size() >= this.inputTopics.size()) {
            ts = Long.MAX_VALUE;
            for (Map.Entry<String, Long> entry : this.topicToTs.entrySet()) {
                ts = Math.min(ts, entry.getValue());
            }
        }
        return ts - this.eventTsLagMs;
    }

    private void checkFailures() {
        if (this.executorFuture != null && this.executorFuture.isDone()) {
            try {
                this.executorFuture.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                log.error("Got exception ", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public void start() {
        this.executorFuture = this.executorService.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables((Runnable)this), this.intervalMs, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        log.debug("Shutting down WaterMarkEventGenerator");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

