/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

class PulsarClientPropertiesProvider
extends CommandLine.PropertiesDefaultProvider {
    private static final String brokerServiceUrlKey = "brokerServiceUrl";
    private final Properties properties;

    private PulsarClientPropertiesProvider(Properties properties) {
        super(properties);
        this.properties = properties;
    }

    static PulsarClientPropertiesProvider create(Properties properties) {
        Properties clone = (Properties)properties.clone();
        String brokerServiceUrl = clone.getProperty(brokerServiceUrlKey);
        if (StringUtils.isBlank((CharSequence)brokerServiceUrl)) {
            String serviceUrl = clone.getProperty("webServiceUrl");
            if (StringUtils.isBlank((CharSequence)serviceUrl)) {
                serviceUrl = clone.getProperty("serviceUrl");
            }
            if (StringUtils.isNotBlank((CharSequence)serviceUrl)) {
                clone.put(brokerServiceUrlKey, serviceUrl);
            }
        }
        return new PulsarClientPropertiesProvider(clone);
    }

    String getServiceUrl() {
        return this.properties.getProperty(brokerServiceUrlKey);
    }
}

