/*
 * Decompiled with CFR 0.152.
 */
package jakarta.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;

public interface JMSContext
extends AutoCloseable {
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;
    public static final int SESSION_TRANSACTED = 0;

    public JMSContext createContext(int var1);

    public JMSProducer createProducer();

    public String getClientID();

    public void setClientID(String var1);

    public ConnectionMetaData getMetaData();

    public ExceptionListener getExceptionListener();

    public void setExceptionListener(ExceptionListener var1);

    public void start();

    public void stop();

    public void setAutoStart(boolean var1);

    public boolean getAutoStart();

    @Override
    public void close();

    public BytesMessage createBytesMessage();

    public MapMessage createMapMessage();

    public Message createMessage();

    public ObjectMessage createObjectMessage();

    public ObjectMessage createObjectMessage(Serializable var1);

    public StreamMessage createStreamMessage();

    public TextMessage createTextMessage();

    public TextMessage createTextMessage(String var1);

    public boolean getTransacted();

    public int getSessionMode();

    public void commit();

    public void rollback();

    public void recover();

    public JMSConsumer createConsumer(Destination var1);

    public JMSConsumer createConsumer(Destination var1, String var2);

    public JMSConsumer createConsumer(Destination var1, String var2, boolean var3);

    public Queue createQueue(String var1);

    public Topic createTopic(String var1);

    public JMSConsumer createDurableConsumer(Topic var1, String var2);

    public JMSConsumer createDurableConsumer(Topic var1, String var2, String var3, boolean var4);

    public JMSConsumer createSharedDurableConsumer(Topic var1, String var2);

    public JMSConsumer createSharedDurableConsumer(Topic var1, String var2, String var3);

    public JMSConsumer createSharedConsumer(Topic var1, String var2);

    public JMSConsumer createSharedConsumer(Topic var1, String var2, String var3);

    public QueueBrowser createBrowser(Queue var1);

    public QueueBrowser createBrowser(Queue var1, String var2);

    public TemporaryQueue createTemporaryQueue();

    public TemporaryTopic createTemporaryTopic();

    public void unsubscribe(String var1);

    public void acknowledge();
}

