/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;

class SignificanceLookup {
    private final QueryShardContext context;
    private final MappedFieldType fieldType;
    private final DocValueFormat format;
    private final Query backgroundFilter;
    private final int supersetNumDocs;
    private TermsEnum termsEnum;

    SignificanceLookup(QueryShardContext context, MappedFieldType fieldType, DocValueFormat format, QueryBuilder backgroundFilter) throws IOException {
        this.context = context;
        this.fieldType = fieldType;
        this.format = format;
        this.backgroundFilter = backgroundFilter == null ? null : backgroundFilter.toQuery(context);
        IndexSearcher searcher = context.searcher();
        this.supersetNumDocs = backgroundFilter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.backgroundFilter);
    }

    long supersetSize() {
        return this.supersetNumDocs;
    }

    BackgroundFrequencyForBytes bytesLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForBytes(){

                @Override
                public long freq(BytesRef term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                @Override
                public void close() {
                }
            };
        }
        return new BackgroundFrequencyForBytes(){
            private final BytesRefHash termToPosition;
            private LongArray positionToFreq;
            {
                this.termToPosition = new BytesRefHash(1L, bigArrays);
                this.positionToFreq = bigArrays.newLongArray(1L, false);
            }

            @Override
            public long freq(BytesRef term) throws IOException {
                long position = this.termToPosition.add(term);
                if (position < 0L) {
                    return this.positionToFreq.get(-1L - position);
                }
                long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                this.positionToFreq.set(position, freq);
                return freq;
            }

            @Override
            public void close() {
                Releasables.close(this.termToPosition, this.positionToFreq);
            }
        };
    }

    private long getBackgroundFrequency(BytesRef term) throws IOException {
        return this.getBackgroundFrequency(this.fieldType.termQuery(this.format.format(term).toString(), this.context));
    }

    BackgroundFrequencyForLong longLookup(final BigArrays bigArrays, CardinalityUpperBound cardinality) {
        if (cardinality == CardinalityUpperBound.ONE) {
            return new BackgroundFrequencyForLong(){

                @Override
                public long freq(long term) throws IOException {
                    return SignificanceLookup.this.getBackgroundFrequency(term);
                }

                @Override
                public void close() {
                }
            };
        }
        return new BackgroundFrequencyForLong(){
            private final LongHash termToPosition;
            private LongArray positionToFreq;
            {
                this.termToPosition = new LongHash(1L, bigArrays);
                this.positionToFreq = bigArrays.newLongArray(1L, false);
            }

            @Override
            public long freq(long term) throws IOException {
                long position = this.termToPosition.add(term);
                if (position < 0L) {
                    return this.positionToFreq.get(-1L - position);
                }
                long freq = SignificanceLookup.this.getBackgroundFrequency(term);
                this.positionToFreq = bigArrays.grow(this.positionToFreq, position + 1L);
                this.positionToFreq.set(position, freq);
                return freq;
            }

            @Override
            public void close() {
                Releasables.close(this.termToPosition, this.positionToFreq);
            }
        };
    }

    private long getBackgroundFrequency(long term) throws IOException {
        return this.getBackgroundFrequency(this.fieldType.termQuery(this.format.format(term).toString(), this.context));
    }

    private long getBackgroundFrequency(Query query) throws IOException {
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            TermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.backgroundFilter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.backgroundFilter, BooleanClause.Occur.FILTER).build();
        }
        return this.context.searcher().count(query);
    }

    private TermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.context.getIndexReader();
        this.termsEnum = new FilterableTermsEnum(reader, this.fieldType.name(), 0, this.backgroundFilter);
        return this.termsEnum;
    }

    static interface BackgroundFrequencyForLong
    extends Releasable {
        public long freq(long var1) throws IOException;
    }

    static interface BackgroundFrequencyForBytes
    extends Releasable {
        public long freq(BytesRef var1) throws IOException;
    }
}

