/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryConfig
implements ToXContentObject {
    private final QueryBuilder query;

    public static QueryConfig fromXContent(XContentParser parser) throws IOException {
        QueryBuilder query = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        return new QueryConfig(query);
    }

    public QueryConfig(QueryBuilder query) {
        this.query = Objects.requireNonNull(query);
    }

    public QueryConfig(QueryConfig queryConfig) {
        this(Objects.requireNonNull(queryConfig).query);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.query.toXContent(builder, params);
        return builder;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryConfig other = (QueryConfig)o;
        return Objects.equals(this.query, other.query);
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

