/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection.AbstractConfusionMatrixMetric;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RecallMetric
extends AbstractConfusionMatrixMetric {
    public static final String NAME = "recall";
    private static final ConstructingObjectParser<RecallMetric, Void> PARSER = new ConstructingObjectParser("recall", args -> new RecallMetric((List)args[0]));

    public static RecallMetric fromXContent(XContentParser parser) {
        return (RecallMetric)PARSER.apply(parser, null);
    }

    public static RecallMetric at(Double ... at) {
        return new RecallMetric(Arrays.asList(at));
    }

    public RecallMetric(List<Double> at) {
        super(at);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecallMetric that = (RecallMetric)o;
        return Arrays.equals(this.thresholds, that.thresholds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.thresholds);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), AT);
    }

    public static class Result
    implements EvaluationMetric.Result {
        private final Map<String, Double> results;

        public static Result fromXContent(XContentParser parser) throws IOException {
            return new Result(parser.map(LinkedHashMap::new, p -> p.doubleValue()));
        }

        public Result(Map<String, Double> results) {
            this.results = Objects.requireNonNull(results);
        }

        @Override
        public String getMetricName() {
            return RecallMetric.NAME;
        }

        public Double getScoreByThreshold(String threshold) {
            return this.results.get(threshold);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.results);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.results, that.results);
        }

        public int hashCode() {
            return Objects.hash(this.results);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

