/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.common;

import com.beust.jcommander.Parameter;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;

public abstract class SubCommandBase {
    @Parameter(names={"--raftGroup", "-g"}, description="Raft group identifier")
    private String raftGroupId = "demoRaftGroup123";
    @Parameter(names={"--peers", "-r"}, description="Raft peers (format: name:host:port:dataStreamPort:clientPort:adminPort,...)", required=true)
    private String peers;

    public static RaftPeer[] parsePeers(String peers) {
        return (RaftPeer[])Stream.of(peers.split(",")).map(address -> {
            String[] addressParts = address.split(":");
            if (addressParts.length < 3) {
                throw new IllegalArgumentException("Raft peer " + address + " is not a legitimate format. (format: name:host:port:dataStreamPort:clientPort:adminPort)");
            }
            RaftPeer.Builder builder = RaftPeer.newBuilder();
            builder.setId(addressParts[0]).setAddress(addressParts[1] + ":" + addressParts[2]);
            if (addressParts.length >= 4) {
                builder.setDataStreamAddress(addressParts[1] + ":" + addressParts[3]);
                if (addressParts.length >= 5) {
                    builder.setClientAddress(addressParts[1] + ":" + addressParts[4]);
                    if (addressParts.length >= 6) {
                        builder.setAdminAddress(addressParts[1] + ":" + addressParts[5]);
                    }
                }
            }
            return builder.build();
        }).toArray(RaftPeer[]::new);
    }

    public RaftPeer[] getPeers() {
        return SubCommandBase.parsePeers(this.peers);
    }

    public RaftPeer getPrimary() {
        return SubCommandBase.parsePeers(this.peers)[0];
    }

    public abstract void run() throws Exception;

    public String getRaftGroupId() {
        return this.raftGroupId;
    }

    public RoutingTable getRoutingTable(Collection<RaftPeer> raftPeers, RaftPeer primary) {
        RoutingTable.Builder builder = RoutingTable.newBuilder();
        RaftPeer previous = primary;
        for (RaftPeer peer : raftPeers) {
            if (peer.equals(primary)) continue;
            builder.addSuccessor(previous.getId(), peer.getId());
            previous = peer;
        }
        return builder.build();
    }

    public RaftPeer getPeer(RaftPeerId raftPeerId) {
        Objects.requireNonNull(raftPeerId, "raftPeerId == null");
        for (RaftPeer p : this.getPeers()) {
            if (!raftPeerId.equals(p.getId())) continue;
            return p;
        }
        throw new IllegalArgumentException("Raft peer id " + raftPeerId + " is not part of the raft group definitions " + this.peers);
    }
}

