/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.filtersrv;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerStartup;
import org.apache.rocketmq.broker.filtersrv.FilterServerUtil;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class FilterServerManager {
    public static final long FILTER_SERVER_MAX_IDLE_TIME_MILLS = 30000L;
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final ConcurrentMap<Channel, FilterServerInfo> filterServerTable = new ConcurrentHashMap<Channel, FilterServerInfo>(16);
    private final BrokerController brokerController;
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("FilterServerManagerScheduledThread"));

    public FilterServerManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    FilterServerManager.this.createFilterServer();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }, 5000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void createFilterServer() {
        int more = this.brokerController.getBrokerConfig().getFilterServerNums() - this.filterServerTable.size();
        String cmd = this.buildStartCommand();
        for (int i = 0; i < more; ++i) {
            FilterServerUtil.callShell(cmd, log);
        }
    }

    private String buildStartCommand() {
        String config = "";
        if (BrokerStartup.configFile != null) {
            config = String.format("-c %s", BrokerStartup.configFile);
        }
        if (this.brokerController.getBrokerConfig().getNamesrvAddr() != null) {
            config = config + String.format(" -n %s", this.brokerController.getBrokerConfig().getNamesrvAddr());
        }
        if (RemotingUtil.isWindowsPlatform()) {
            return String.format("start /b %s\\bin\\mqfiltersrv.exe %s", this.brokerController.getBrokerConfig().getRocketmqHome(), config);
        }
        return String.format("sh %s/bin/startfsrv.sh %s", this.brokerController.getBrokerConfig().getRocketmqHome(), config);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public void registerFilterServer(Channel channel, String filterServerAddr) {
        FilterServerInfo filterServerInfo = (FilterServerInfo)this.filterServerTable.get(channel);
        if (filterServerInfo != null) {
            filterServerInfo.setLastUpdateTimestamp(System.currentTimeMillis());
        } else {
            filterServerInfo = new FilterServerInfo();
            filterServerInfo.setFilterServerAddr(filterServerAddr);
            filterServerInfo.setLastUpdateTimestamp(System.currentTimeMillis());
            this.filterServerTable.put(channel, filterServerInfo);
            log.info("Receive a New Filter Server<{}>", (Object)filterServerAddr);
        }
    }

    public void scanNotActiveChannel() {
        Iterator it = this.filterServerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            long timestamp = ((FilterServerInfo)next.getValue()).getLastUpdateTimestamp();
            Channel channel = (Channel)next.getKey();
            if (System.currentTimeMillis() - timestamp <= 30000L) continue;
            log.info("The Filter Server<{}> expired, remove it", next.getKey());
            it.remove();
            RemotingUtil.closeChannel((Channel)channel);
        }
    }

    public void doChannelCloseEvent(String remoteAddr, Channel channel) {
        FilterServerInfo old = (FilterServerInfo)this.filterServerTable.remove(channel);
        if (old != null) {
            log.warn("The Filter Server<{}> connection<{}> closed, remove it", (Object)old.getFilterServerAddr(), (Object)remoteAddr);
        }
    }

    public List<String> buildNewFilterServerList() {
        ArrayList<String> addr = new ArrayList<String>();
        for (Map.Entry next : this.filterServerTable.entrySet()) {
            addr.add(((FilterServerInfo)next.getValue()).getFilterServerAddr());
        }
        return addr;
    }

    static class FilterServerInfo {
        private String filterServerAddr;
        private long lastUpdateTimestamp;

        FilterServerInfo() {
        }

        public String getFilterServerAddr() {
            return this.filterServerAddr;
        }

        public void setFilterServerAddr(String filterServerAddr) {
            this.filterServerAddr = filterServerAddr;
        }

        public long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }
    }
}

