/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.dledger;

import io.openmessaging.storage.dledger.DLedgerLeaderElector;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.dledger.DLedgerCommitLog;

public class DLedgerRoleChangeHandler
implements DLedgerLeaderElector.RoleChangeHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private ExecutorService executorService;
    private BrokerController brokerController;
    private DefaultMessageStore messageStore;
    private DLedgerCommitLog dLedgerCommitLog;
    private DLedgerServer dLegerServer;
    private Future<?> slaveSyncFuture;
    private long lastSyncTimeMs = System.currentTimeMillis();

    public DLedgerRoleChangeHandler(BrokerController brokerController, DefaultMessageStore messageStore) {
        this.brokerController = brokerController;
        this.messageStore = messageStore;
        this.dLedgerCommitLog = (DLedgerCommitLog)messageStore.getCommitLog();
        this.dLegerServer = this.dLedgerCommitLog.getdLedgerServer();
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("DLegerRoleChangeHandler_", brokerController.getBrokerIdentity()));
    }

    public void handle(final long term, final MemberState.Role role) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    boolean succ = true;
                    LOGGER.info("Begin handling broker role change term={} role={} currStoreRole={}", new Object[]{term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole()});
                    switch (role) {
                        case CANDIDATE: {
                            if (DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE) break;
                            DLedgerRoleChangeHandler.this.changeToSlave(DLedgerRoleChangeHandler.this.dLedgerCommitLog.getId());
                            break;
                        }
                        case FOLLOWER: {
                            DLedgerRoleChangeHandler.this.changeToSlave(DLedgerRoleChangeHandler.this.dLedgerCommitLog.getId());
                            break;
                        }
                        case LEADER: {
                            while (true) {
                                if (!DLedgerRoleChangeHandler.this.dLegerServer.getMemberState().isLeader()) {
                                    succ = false;
                                    break;
                                }
                                if (DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getLedgerEndIndex() == -1L || DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getLedgerEndIndex() == DLedgerRoleChangeHandler.this.dLegerServer.getdLedgerStore().getCommittedIndex() && DLedgerRoleChangeHandler.this.messageStore.dispatchBehindBytes() == 0L) break;
                                Thread.sleep(100L);
                            }
                            if (!succ) break;
                            DLedgerRoleChangeHandler.this.messageStore.recoverTopicQueueTable();
                            DLedgerRoleChangeHandler.this.changeToMaster(BrokerRole.SYNC_MASTER);
                            break;
                        }
                    }
                    LOGGER.info("Finish handling broker role change succ={} term={} role={} currStoreRole={} cost={}", new Object[]{succ, term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole(), DLedgerUtils.elapsed((long)start)});
                }
                catch (Throwable t) {
                    LOGGER.info("[MONITOR]Failed handling broker role change term={} role={} currStoreRole={} cost={}", new Object[]{term, role, DLedgerRoleChangeHandler.this.messageStore.getMessageStoreConfig().getBrokerRole(), DLedgerUtils.elapsed((long)start), t});
                }
            }
        };
        this.executorService.submit(runnable);
    }

    private void handleSlaveSynchronize(BrokerRole role) {
        if (role == BrokerRole.SLAVE) {
            if (null != this.slaveSyncFuture) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(null);
            this.slaveSyncFuture = this.brokerController.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (System.currentTimeMillis() - DLedgerRoleChangeHandler.this.lastSyncTimeMs > 10000L) {
                            DLedgerRoleChangeHandler.this.brokerController.getSlaveSynchronize().syncAll();
                            DLedgerRoleChangeHandler.this.lastSyncTimeMs = System.currentTimeMillis();
                        }
                        DLedgerRoleChangeHandler.this.brokerController.getSlaveSynchronize().syncTimerCheckPoint();
                    }
                    catch (Throwable e) {
                        LOGGER.error("ScheduledTask SlaveSynchronize syncAll error.", e);
                    }
                }
            }, 3000L, 3000L, TimeUnit.MILLISECONDS);
        } else {
            if (null != this.slaveSyncFuture) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(null);
        }
    }

    public void changeToSlave(int brokerId) {
        LOGGER.info("Begin to change to slave brokerName={} brokerId={}", (Object)this.brokerController.getBrokerConfig().getBrokerName(), (Object)brokerId);
        this.brokerController.getBrokerConfig().setBrokerId(brokerId == 0 ? 1L : (long)brokerId);
        this.brokerController.getMessageStoreConfig().setBrokerRole(BrokerRole.SLAVE);
        this.brokerController.changeSpecialServiceStatus(false);
        this.handleSlaveSynchronize(BrokerRole.SLAVE);
        try {
            this.brokerController.registerBrokerAll(true, true, this.brokerController.getBrokerConfig().isForceRegister());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGER.info("Finish to change to slave brokerName={} brokerId={}", (Object)this.brokerController.getBrokerConfig().getBrokerName(), (Object)brokerId);
    }

    public void changeToMaster(BrokerRole role) {
        if (role == BrokerRole.SLAVE) {
            return;
        }
        LOGGER.info("Begin to change to master brokerName={}", (Object)this.brokerController.getBrokerConfig().getBrokerName());
        this.handleSlaveSynchronize(role);
        this.brokerController.changeSpecialServiceStatus(true);
        this.brokerController.getBrokerConfig().setBrokerId(0L);
        this.brokerController.getMessageStoreConfig().setBrokerRole(role);
        try {
            this.brokerController.registerBrokerAll(true, true, this.brokerController.getBrokerConfig().isForceRegister());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGER.info("Finish to change to master brokerName={}", (Object)this.brokerController.getBrokerConfig().getBrokerName());
    }

    public void startup() {
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

