/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.broker.topic.TopicQueueMappingManager;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.GetTopicConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.GetTopicStatsInfoRequestHeader;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.rpc.ClientMetadata;
import org.apache.rocketmq.common.rpc.RpcClient;
import org.apache.rocketmq.common.rpc.RpcRequest;
import org.apache.rocketmq.common.rpc.RpcRequestHeader;
import org.apache.rocketmq.common.rpc.RpcResponse;
import org.apache.rocketmq.common.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.common.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class TopicQueueMappingCleanService
extends ServiceThread {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private TopicQueueMappingManager topicQueueMappingManager;
    private BrokerOuterAPI brokerOuterAPI;
    private RpcClient rpcClient;
    private MessageStoreConfig messageStoreConfig;
    private BrokerConfig brokerConfig;
    private BrokerController brokerController;

    public TopicQueueMappingCleanService(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.topicQueueMappingManager = brokerController.getTopicQueueMappingManager();
        this.rpcClient = brokerController.getBrokerOuterAPI().getRpcClient();
        this.messageStoreConfig = brokerController.getMessageStoreConfig();
        this.brokerConfig = brokerController.getBrokerConfig();
        this.brokerOuterAPI = brokerController.getBrokerOuterAPI();
    }

    public String getServiceName() {
        if (this.brokerConfig.isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getLoggerIdentifier() + TopicQueueMappingCleanService.class.getSimpleName();
        }
        return TopicQueueMappingCleanService.class.getSimpleName();
    }

    public void run() {
        log.info("Start topic queue mapping clean service thread!");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(300000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.cleanItemExpired();
            }
            catch (Throwable t) {
                log.error("topic queue mapping cleanItemExpired failed", t);
            }
            try {
                this.cleanItemListMoreThanSecondGen();
            }
            catch (Throwable t) {
                log.error("topic queue mapping cleanItemListMoreThanSecondGen failed", t);
            }
        }
        log.info("End topic queue mapping clean service  thread!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanItemExpired() {
        String when = this.messageStoreConfig.getDeleteWhen();
        if (!UtilAll.isItTimeToDo((String)when)) {
            return;
        }
        boolean changed = false;
        long start = System.currentTimeMillis();
        try {
            for (String topic : this.topicQueueMappingManager.getTopicQueueMappingTable().keySet()) {
                try {
                    if (!this.isStopped()) {
                        Object items22;
                        TopicQueueMappingDetail mappingDetail = (TopicQueueMappingDetail)this.topicQueueMappingManager.getTopicQueueMappingTable().get(topic);
                        if (mappingDetail == null || mappingDetail.getHostedQueues().isEmpty()) continue;
                        if (!mappingDetail.getBname().equals(this.brokerConfig.getBrokerName())) {
                            log.warn("The TopicQueueMappingDetail [{}] should not exist in this broker", (Object)mappingDetail);
                            continue;
                        }
                        HashSet<String> brokers = new HashSet<String>();
                        for (Object items22 : mappingDetail.getHostedQueues().values()) {
                            if (items22.size() <= 1 || !TopicQueueMappingUtils.checkIfLeader((List)items22, (TopicQueueMappingDetail)mappingDetail)) continue;
                            LogicQueueMappingItem earlistItem = (LogicQueueMappingItem)items22.get(0);
                            brokers.add(earlistItem.getBname());
                        }
                        HashMap<String, TopicStatsTable> statsTable = new HashMap<String, TopicStatsTable>();
                        items22 = brokers.iterator();
                        while (items22.hasNext()) {
                            String broker = (String)items22.next();
                            GetTopicStatsInfoRequestHeader header = new GetTopicStatsInfoRequestHeader();
                            header.setTopic(topic);
                            header.setBname(broker);
                            header.setLo(Boolean.valueOf(false));
                            try {
                                RpcRequest rpcRequest = new RpcRequest(202, (RpcRequestHeader)header, null);
                                RpcResponse rpcResponse = (RpcResponse)this.rpcClient.invoke(rpcRequest, this.brokerConfig.getForwardTimeout()).get();
                                if (rpcResponse.getException() != null) {
                                    throw rpcResponse.getException();
                                }
                                statsTable.put(broker, (TopicStatsTable)rpcResponse.getBody());
                            }
                            catch (Throwable throwable) {
                                log.error("Get remote topic {} state info failed from broker {}", new Object[]{topic, broker, throwable});
                            }
                        }
                        HashMap newHostedQueues = new HashMap();
                        boolean changedForTopic = false;
                        for (Map.Entry entry : mappingDetail.getHostedQueues().entrySet()) {
                            LogicQueueMappingItem earlistItem;
                            TopicStatsTable topicStats;
                            Integer qid = (Integer)entry.getKey();
                            List items3 = (List)entry.getValue();
                            if (items3.size() <= 1 || !TopicQueueMappingUtils.checkIfLeader((List)items3, (TopicQueueMappingDetail)mappingDetail) || (topicStats = (TopicStatsTable)statsTable.get((earlistItem = (LogicQueueMappingItem)items3.get(0)).getBname())) == null) continue;
                            TopicOffset topicOffset = (TopicOffset)topicStats.getOffsetTable().get(new MessageQueue(topic, earlistItem.getBname(), earlistItem.getQueueId()));
                            if (topicOffset == null) {
                                log.error("Get null topicOffset for {} {}", (Object)topic, (Object)earlistItem);
                                continue;
                            }
                            if (topicOffset.getMaxOffset() != topicOffset.getMinOffset() && topicOffset.getMaxOffset() != 0L) continue;
                            ArrayList newItems = new ArrayList(items3);
                            boolean result = newItems.remove(earlistItem);
                            if (result) {
                                changedForTopic = true;
                                newHostedQueues.put(qid, newItems);
                            }
                            log.info("The logic queue item {} {} is removed {} because of {}", new Object[]{topic, earlistItem, result, topicOffset});
                        }
                        if (!changedForTopic) continue;
                        TopicQueueMappingDetail newMappingDetail = new TopicQueueMappingDetail(mappingDetail.getTopic(), mappingDetail.getTotalQueues(), mappingDetail.getBname(), mappingDetail.getEpoch());
                        newMappingDetail.getHostedQueues().putAll(mappingDetail.getHostedQueues());
                        newMappingDetail.getHostedQueues().putAll(newHostedQueues);
                        this.topicQueueMappingManager.updateTopicQueueMapping(newMappingDetail, false, true, false);
                        changed = true;
                        continue;
                    }
                    break;
                }
                catch (Throwable tt) {
                    log.error("Try CleanItemExpired failed for {}", (Object)topic, (Object)tt);
                }
                finally {
                    UtilAll.sleep((long)10L);
                }
            }
        }
        catch (Throwable t) {
            log.error("Try cleanItemExpired failed", t);
        }
        finally {
            if (changed) {
                this.topicQueueMappingManager.getDataVersion().nextVersion();
                this.topicQueueMappingManager.persist();
                log.info("CleanItemExpired changed");
            }
            log.info("cleanItemExpired cost {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanItemListMoreThanSecondGen() {
        String when = this.messageStoreConfig.getDeleteWhen();
        if (!UtilAll.isItTimeToDo((String)when)) {
            return;
        }
        boolean changed = false;
        long start = System.currentTimeMillis();
        try {
            ClientMetadata clientMetadata = new ClientMetadata();
            for (String topic : this.topicQueueMappingManager.getTopicQueueMappingTable().keySet()) {
                try {
                    if (!this.isStopped()) {
                        TopicQueueMappingDetail mappingDetail = (TopicQueueMappingDetail)this.topicQueueMappingManager.getTopicQueueMappingTable().get(topic);
                        if (mappingDetail == null || mappingDetail.getHostedQueues().isEmpty()) continue;
                        if (!mappingDetail.getBname().equals(this.brokerConfig.getBrokerName())) {
                            log.warn("The TopicQueueMappingDetail [{}] should not exist in this broker", (Object)mappingDetail);
                            continue;
                        }
                        HashMap<Object, String> qid2CurrLeaderBroker = new HashMap<Object, String>();
                        for (Map.Entry entry2 : mappingDetail.getHostedQueues().entrySet()) {
                            LogicQueueMappingItem leaderItem;
                            Integer qId = (Integer)entry2.getKey();
                            List list = (List)entry2.getValue();
                            if (list.isEmpty() || (leaderItem = (LogicQueueMappingItem)list.get(list.size() - 1)).getBname().equals(mappingDetail.getBname())) continue;
                            qid2CurrLeaderBroker.put(qId, leaderItem.getBname());
                        }
                        if (qid2CurrLeaderBroker.isEmpty()) continue;
                        TopicRouteData topicRouteData = this.brokerOuterAPI.getTopicRouteInfoFromNameServer(topic, this.brokerConfig.getForwardTimeout());
                        clientMetadata.freshTopicRoute(topic, topicRouteData);
                        HashMap qid2RealLeaderBroker = new HashMap();
                        for (Map.Entry entry : qid2CurrLeaderBroker.entrySet()) {
                            qid2RealLeaderBroker.put(entry.getKey(), clientMetadata.getBrokerNameFromMessageQueue(new MessageQueue(topic, TopicQueueMappingUtils.getMockBrokerName((String)mappingDetail.getScope()), ((Integer)entry.getKey()).intValue())));
                        }
                        HashMap<String, TopicQueueMappingDetail> mappingDetailMap = new HashMap<String, TopicQueueMappingDetail>();
                        for (Map.Entry entry4 : qid2RealLeaderBroker.entrySet()) {
                            if (((String)entry4.getValue()).startsWith("__syslo__")) continue;
                            String broker = (String)entry4.getValue();
                            GetTopicConfigRequestHeader header = new GetTopicConfigRequestHeader();
                            header.setTopic(topic);
                            header.setBname(broker);
                            header.setLo(Boolean.valueOf(true));
                            try {
                                RpcRequest rpcRequest = new RpcRequest(351, (RpcRequestHeader)header, null);
                                RpcResponse rpcResponse = (RpcResponse)this.rpcClient.invoke(rpcRequest, this.brokerConfig.getForwardTimeout()).get();
                                if (rpcResponse.getException() != null) {
                                    throw rpcResponse.getException();
                                }
                                TopicQueueMappingDetail mappingDetailRemote = ((TopicConfigAndQueueMapping)rpcResponse.getBody()).getMappingDetail();
                                if (!broker.equals(mappingDetailRemote.getBname())) continue;
                                mappingDetailMap.put(broker, mappingDetailRemote);
                            }
                            catch (Throwable rt) {
                                log.error("Get remote topic {} state info failed from broker {}", new Object[]{topic, broker, rt});
                            }
                        }
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        for (Map.Entry entry5 : qid2CurrLeaderBroker.entrySet()) {
                            LogicQueueMappingItem leaderItem;
                            List items;
                            Integer qId = (Integer)entry5.getKey();
                            String currLeaderBroker = (String)entry5.getValue();
                            String realLeaderBroker = (String)qid2RealLeaderBroker.get(qId);
                            TopicQueueMappingDetail remoteMappingDetail = (TopicQueueMappingDetail)mappingDetailMap.get(realLeaderBroker);
                            if (remoteMappingDetail == null || remoteMappingDetail.getTotalQueues() != mappingDetail.getTotalQueues() || remoteMappingDetail.getEpoch() != mappingDetail.getEpoch() || (items = (List)remoteMappingDetail.getHostedQueues().get(qId)).isEmpty() || !realLeaderBroker.equals((leaderItem = (LogicQueueMappingItem)items.get(items.size() - 1)).getBname()) || realLeaderBroker.equals(currLeaderBroker)) continue;
                            hashSet.add(qId);
                        }
                        for (Integer qid : hashSet) {
                            List items = (List)mappingDetail.getHostedQueues().remove(qid);
                            changed = true;
                            if (items == null) continue;
                            log.info("Remove the ItemListMoreThanSecondGen topic {} qid {} items {}", new Object[]{topic, qid, items});
                        }
                        continue;
                    }
                    break;
                }
                catch (Throwable tt) {
                    log.error("Try cleanItemListMoreThanSecondGen failed for topic {}", (Object)topic, (Object)tt);
                }
                finally {
                    UtilAll.sleep((long)10L);
                }
            }
        }
        catch (Throwable t) {
            log.error("Try cleanItemListMoreThanSecondGen failed", t);
        }
        finally {
            if (changed) {
                this.topicQueueMappingManager.getDataVersion().nextVersion();
                this.topicQueueMappingManager.persist();
            }
            log.info("Try cleanItemListMoreThanSecondGen cost {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }
}

