/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.schedule.ScheduleMessageService;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.BrokerRole;

public class HookUtils {
    protected static final InternalLogger LOG = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static AtomicLong printTimes = new AtomicLong(0L);

    public static PutMessageResult checkBeforePutMessage(BrokerController brokerController, MessageExt msg) {
        int topicLength;
        if (brokerController.getMessageStore().isShutdown()) {
            LOG.warn("message store has shutdown, so putMessage is forbidden");
            return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
        }
        if (!brokerController.getMessageStoreConfig().isDuplicationEnable() && BrokerRole.SLAVE == brokerController.getMessageStoreConfig().getBrokerRole()) {
            long value = printTimes.getAndIncrement();
            if (value % 50000L == 0L) {
                LOG.warn("message store is in slave mode, so putMessage is forbidden ");
            }
            return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
        }
        if (!brokerController.getMessageStore().getRunningFlags().isWriteable()) {
            long value = printTimes.getAndIncrement();
            if (value % 50000L == 0L) {
                LOG.warn("message store is not writeable, so putMessage is forbidden " + brokerController.getMessageStore().getRunningFlags().getFlagBits());
            }
            return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
        }
        printTimes.set(0L);
        byte[] topicData = msg.getTopic().getBytes(MessageDecoder.CHARSET_UTF8);
        int n = topicLength = topicData == null ? 0 : topicData.length;
        if (topicLength > brokerController.getMessageStoreConfig().getMaxTopicLength()) {
            LOG.warn("putMessage message topic[{}] length too long {}", (Object)msg.getTopic(), (Object)topicLength);
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        if (topicLength > 127) {
            LOG.warn("putMessage message topic[{}] length too long {}, but it is not supported by broker", (Object)msg.getTopic(), (Object)topicLength);
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        if (msg.getBody() == null) {
            LOG.warn("putMessage message topic[{}], but message body is null", (Object)msg.getTopic());
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        if (msg.getBody() == null) {
            LOG.warn("putMessage message topic[{}], but message body is null", (Object)msg.getTopic());
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        if (brokerController.getMessageStore().isOSPageCacheBusy()) {
            return new PutMessageResult(PutMessageStatus.OS_PAGE_CACHE_BUSY, null);
        }
        return null;
    }

    public static PutMessageResult checkInnerBatch(BrokerController brokerController, MessageExt msg) {
        Optional topicConfig;
        if (msg.getProperties().containsKey("INNER_NUM") && !MessageSysFlag.check((int)msg.getSysFlag(), (int)128)) {
            LOG.warn("[BUG]The message had property {} but is not an inner batch", (Object)"INNER_NUM");
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        if (MessageSysFlag.check((int)msg.getSysFlag(), (int)128) && !QueueTypeUtils.isBatchCq(topicConfig = Optional.ofNullable(brokerController.getTopicConfigManager().getTopicConfigTable().get(msg.getTopic())))) {
            LOG.error("[BUG]The message is an inner batch but cq type is not batch cq");
            return new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null);
        }
        return null;
    }

    public static PutMessageResult handleScheduleMessage(BrokerController brokerController, MessageExtBrokerInner msg) {
        int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        if (tranType == 0 || tranType == 8) {
            if (!HookUtils.isRolledTimerMessage(msg) && HookUtils.checkIfTimerMessage(msg)) {
                if (!brokerController.getMessageStoreConfig().isTimerWheelEnable()) {
                    return new PutMessageResult(PutMessageStatus.WHEEL_TIMER_NOT_ENABLE, null);
                }
                PutMessageResult tranformRes = HookUtils.transformTimerMessage(brokerController, msg);
                if (null != tranformRes) {
                    return tranformRes;
                }
            }
            if (msg.getDelayTimeLevel() > 0) {
                HookUtils.transformDelayLevelMessage(brokerController, msg);
            }
        }
        return null;
    }

    private static boolean isRolledTimerMessage(MessageExtBrokerInner msg) {
        return "rmq_sys_wheel_timer".equals(msg.getTopic());
    }

    public static boolean checkIfTimerMessage(MessageExtBrokerInner msg) {
        if (msg.getDelayTimeLevel() > 0) {
            if (null != msg.getProperty("TIMER_DELIVER_MS")) {
                MessageAccessor.clearProperty((Message)msg, (String)"TIMER_DELIVER_MS");
            }
            if (null != msg.getProperty("TIMER_DELAY_SEC")) {
                MessageAccessor.clearProperty((Message)msg, (String)"TIMER_DELAY_SEC");
            }
            if (null != msg.getProperty("TIMER_DELAY_MS")) {
                MessageAccessor.clearProperty((Message)msg, (String)"TIMER_DELAY_MS");
            }
            return false;
        }
        if ("rmq_sys_wheel_timer".equals(msg.getTopic()) || null != msg.getProperty("TIMER_OUT_MS")) {
            return false;
        }
        return null != msg.getProperty("TIMER_DELIVER_MS") || null != msg.getProperty("TIMER_DELAY_MS") || null != msg.getProperty("TIMER_DELAY_SEC");
    }

    private static PutMessageResult transformTimerMessage(BrokerController brokerController, MessageExtBrokerInner msg) {
        long deliverMs;
        int delayLevel = msg.getDelayTimeLevel();
        try {
            deliverMs = msg.getProperty("TIMER_DELAY_SEC") != null ? System.currentTimeMillis() + Long.parseLong(msg.getProperty("TIMER_DELAY_SEC")) * 1000L : (msg.getProperty("TIMER_DELAY_MS") != null ? System.currentTimeMillis() + Long.parseLong(msg.getProperty("TIMER_DELAY_MS")) : Long.parseLong(msg.getProperty("TIMER_DELIVER_MS")));
        }
        catch (Exception e) {
            return new PutMessageResult(PutMessageStatus.WHEEL_TIMER_MSG_ILLEGAL, null);
        }
        if (deliverMs > System.currentTimeMillis()) {
            if (delayLevel <= 0 && deliverMs - System.currentTimeMillis() > (long)(brokerController.getMessageStoreConfig().getTimerMaxDelaySec() * 1000)) {
                return new PutMessageResult(PutMessageStatus.WHEEL_TIMER_MSG_ILLEGAL, null);
            }
            int timerPrecisionMs = brokerController.getMessageStoreConfig().getTimerPrecisionMs();
            deliverMs = deliverMs % (long)timerPrecisionMs == 0L ? (deliverMs -= (long)timerPrecisionMs) : deliverMs / (long)timerPrecisionMs * (long)timerPrecisionMs;
            if (brokerController.getTimerMessageStore().isReject(deliverMs)) {
                return new PutMessageResult(PutMessageStatus.WHEEL_TIMER_FLOW_CONTROL, null);
            }
            MessageAccessor.putProperty((Message)msg, (String)"TIMER_OUT_MS", (String)(deliverMs + ""));
            MessageAccessor.putProperty((Message)msg, (String)"REAL_TOPIC", (String)msg.getTopic());
            MessageAccessor.putProperty((Message)msg, (String)"REAL_QID", (String)String.valueOf(msg.getQueueId()));
            msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
            msg.setTopic("rmq_sys_wheel_timer");
            msg.setQueueId(0);
        } else if (null != msg.getProperty("TIMER_DEL_UNIQKEY")) {
            return new PutMessageResult(PutMessageStatus.WHEEL_TIMER_MSG_ILLEGAL, null);
        }
        return null;
    }

    public static void transformDelayLevelMessage(BrokerController brokerController, MessageExtBrokerInner msg) {
        if (msg.getDelayTimeLevel() > brokerController.getScheduleMessageService().getMaxDelayLevel()) {
            msg.setDelayTimeLevel(brokerController.getScheduleMessageService().getMaxDelayLevel());
        }
        MessageAccessor.putProperty((Message)msg, (String)"REAL_TOPIC", (String)msg.getTopic());
        MessageAccessor.putProperty((Message)msg, (String)"REAL_QID", (String)String.valueOf(msg.getQueueId()));
        msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
        msg.setTopic("SCHEDULE_TOPIC_XXXX");
        msg.setQueueId(ScheduleMessageService.delayLevel2QueueId(msg.getDelayTimeLevel()));
    }

    public static boolean sendMessageBack(BrokerController brokerController, List<MessageExt> msgList, String brokerName, String brokerAddr) {
        try {
            Iterator<MessageExt> it = msgList.iterator();
            while (it.hasNext()) {
                MessageExt msg = it.next();
                msg.setWaitStoreMsgOK(false);
                brokerController.getBrokerOuterAPI().sendMessageToSpecificBroker(brokerAddr, brokerName, msg, "InnerSendMessageBackGroup", 3000L);
                it.remove();
            }
        }
        catch (Exception e) {
            LOG.error("send message back to broker {} addr {} failed", new Object[]{brokerName, brokerAddr, e});
            return false;
        }
        return true;
    }
}

