/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.container.BrokerBootHook;
import org.apache.rocketmq.container.BrokerContainer;
import org.apache.rocketmq.container.BrokerContainerConfig;
import org.apache.rocketmq.container.InnerBrokerController;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerContainerStartup {
    private static final String BROKER_CONTAINER_CONFIG_OPTION = "c";
    private static final String BROKER_CONFIG_OPTION = "b";
    private static final String PRINT_PROPERTIES_OPTION = "p";
    private static final String PRINT_IMPORTANT_PROPERTIES_OPTION = "m";
    public static Properties properties = null;
    public static CommandLine commandLine = null;
    public static String configFile = null;
    public static InternalLogger log;
    public static final SystemConfigFileHelper CONFIG_FILE_HELPER;
    public static String rocketmqHome;
    public static final JoranConfigurator CONFIGURATOR;

    public static void main(String[] args) {
        BrokerContainer brokerContainer = BrokerContainerStartup.startBrokerContainer(BrokerContainerStartup.createBrokerContainer(args));
        BrokerContainerStartup.createAndStartBrokers(brokerContainer);
    }

    public static BrokerController createBrokerController(String[] args) {
        BrokerContainer brokerContainer = BrokerContainerStartup.startBrokerContainer(BrokerContainerStartup.createBrokerContainer(args));
        return BrokerContainerStartup.createAndInitializeBroker(brokerContainer, configFile, properties);
    }

    public static List<BrokerController> createAndStartBrokers(BrokerContainer brokerContainer) {
        String[] configPaths = BrokerContainerStartup.parseBrokerConfigPath();
        ArrayList<BrokerController> brokerControllerList = new ArrayList<BrokerController>();
        if (configPaths != null && configPaths.length > 0) {
            SystemConfigFileHelper configFileHelper = new SystemConfigFileHelper();
            for (String configPath : configPaths) {
                System.out.printf("Start broker from config file path %s%n", configPath);
                configFileHelper.setFile(configPath);
                Properties brokerProperties = null;
                try {
                    brokerProperties = configFileHelper.loadConfig();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                BrokerController brokerController = BrokerContainerStartup.createAndInitializeBroker(brokerContainer, configPath, brokerProperties);
                if (brokerController == null) continue;
                brokerControllerList.add(brokerController);
                BrokerContainerStartup.startBrokerController(brokerContainer, brokerController, brokerProperties);
            }
        }
        return brokerControllerList;
    }

    public static String[] parseBrokerConfigPath() {
        String brokerContainerConfigPath;
        String brokerConfigList = null;
        if (commandLine.hasOption(BROKER_CONFIG_OPTION)) {
            brokerConfigList = commandLine.getOptionValue(BROKER_CONFIG_OPTION);
        } else if (commandLine.hasOption(BROKER_CONTAINER_CONFIG_OPTION) && (brokerContainerConfigPath = commandLine.getOptionValue(BROKER_CONTAINER_CONFIG_OPTION)) != null) {
            BrokerContainerConfig brokerContainerConfig = new BrokerContainerConfig();
            SystemConfigFileHelper configFileHelper = new SystemConfigFileHelper();
            configFileHelper.setFile(brokerContainerConfigPath);
            Properties brokerContainerProperties = null;
            try {
                brokerContainerProperties = configFileHelper.loadConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
            if (brokerContainerProperties != null) {
                MixAll.properties2Object((Properties)brokerContainerProperties, (Object)brokerContainerConfig);
            }
            brokerConfigList = brokerContainerConfig.getBrokerConfigPaths();
        }
        if (brokerConfigList != null) {
            return brokerConfigList.split(":");
        }
        return null;
    }

    public static BrokerController createAndInitializeBroker(BrokerContainer brokerContainer, String filePath, Properties brokerProperties) {
        BrokerConfig brokerConfig = new BrokerConfig();
        MessageStoreConfig messageStoreConfig = new MessageStoreConfig();
        if (brokerProperties != null) {
            BrokerContainerStartup.properties2SystemEnv(brokerProperties);
            MixAll.properties2Object((Properties)brokerProperties, (Object)brokerConfig);
            MixAll.properties2Object((Properties)brokerProperties, (Object)messageStoreConfig);
        }
        messageStoreConfig.setHaListenPort(brokerConfig.getListenPort() + 1);
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)brokerConfig);
        if (!brokerConfig.isEnableControllerMode()) {
            switch (messageStoreConfig.getBrokerRole()) {
                case ASYNC_MASTER: 
                case SYNC_MASTER: {
                    brokerConfig.setBrokerId(0L);
                    break;
                }
                case SLAVE: {
                    if (brokerConfig.getBrokerId() > 0L) break;
                    System.out.printf("Slave's brokerId must be > 0%n", new Object[0]);
                    System.exit(-3);
                    break;
                }
            }
        }
        if (messageStoreConfig.getTotalReplicas() < messageStoreConfig.getInSyncReplicas() || messageStoreConfig.getTotalReplicas() < messageStoreConfig.getMinInSyncReplicas() || messageStoreConfig.getInSyncReplicas() < messageStoreConfig.getMinInSyncReplicas()) {
            System.out.printf("invalid replicas number%n", new Object[0]);
            System.exit(-3);
        }
        brokerConfig.setBrokerConfigPath(filePath);
        log = InternalLoggerFactory.getLogger((String)(brokerConfig.getLoggerIdentifier() + "RocketmqBroker"));
        MixAll.printObjectProperties((InternalLogger)log, (Object)brokerConfig);
        MixAll.printObjectProperties((InternalLogger)log, (Object)messageStoreConfig);
        try {
            InnerBrokerController brokerController = brokerContainer.addBroker(brokerConfig, messageStoreConfig);
            if (brokerController != null) {
                brokerController.getConfiguration().registerConfig(brokerProperties);
                return brokerController;
            }
            System.out.printf("Add broker [%s-%s] failed.%n", brokerConfig.getBrokerName(), brokerConfig.getBrokerId());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return null;
    }

    public static BrokerContainer startBrokerContainer(BrokerContainer brokerContainer) {
        try {
            brokerContainer.start();
            String tip = "The broker container boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
            if (null != brokerContainer.getBrokerContainerConfig().getNamesrvAddr()) {
                tip = tip + " and name server is " + brokerContainer.getBrokerContainerConfig().getNamesrvAddr();
            }
            log.info(tip);
            System.out.printf("%s%n", tip);
            return brokerContainer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static void startBrokerController(BrokerContainer brokerContainer, BrokerController brokerController, Properties brokerProperties) {
        try {
            for (BrokerBootHook hook : brokerContainer.getBrokerBootHookList()) {
                hook.executeBeforeStart(brokerController, brokerProperties);
            }
            brokerController.start();
            for (BrokerBootHook hook : brokerContainer.getBrokerBootHookList()) {
                hook.executeAfterStart(brokerController, brokerProperties);
            }
            String tip = String.format("Broker [%s-%s] boot success. serializeType=%s", brokerController.getBrokerConfig().getBrokerName(), brokerController.getBrokerConfig().getBrokerId(), RemotingCommand.getSerializeTypeConfigInThisServer());
            log.info(tip);
            System.out.printf("%s%n", tip);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void shutdown(BrokerContainer controller) {
        if (null != controller) {
            controller.shutdown();
        }
    }

    public static BrokerContainer createBrokerContainer(String[] args) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        if (null == System.getProperty("com.rocketmq.remoting.socket.sndbuf.size")) {
            NettySystemConfig.socketSndbufSize = 131072;
        }
        if (null == System.getProperty("com.rocketmq.remoting.socket.rcvbuf.size")) {
            NettySystemConfig.socketRcvbufSize = 131072;
        }
        try {
            InternalLogger console;
            String file;
            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
            commandLine = ServerUtil.parseCmdLine((String)"mqbroker", (String[])args, (Options)BrokerContainerStartup.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
            if (null == commandLine) {
                System.exit(-1);
            }
            BrokerContainerConfig containerConfig = new BrokerContainerConfig();
            NettyServerConfig nettyServerConfig = new NettyServerConfig();
            NettyClientConfig nettyClientConfig = new NettyClientConfig();
            nettyClientConfig.setUseTLS(Boolean.parseBoolean(System.getProperty("tls.enable", String.valueOf(TlsSystemConfig.tlsMode == TlsMode.ENFORCING))));
            nettyServerConfig.setListenPort(10811);
            if (commandLine.hasOption(BROKER_CONTAINER_CONFIG_OPTION) && (file = commandLine.getOptionValue(BROKER_CONTAINER_CONFIG_OPTION)) != null) {
                CONFIG_FILE_HELPER.setFile(file);
                configFile = file;
                BrokerPathConfigHelper.setBrokerConfigPath((String)file);
            }
            if ((properties = CONFIG_FILE_HELPER.loadConfig()) != null) {
                BrokerContainerStartup.properties2SystemEnv(properties);
                MixAll.properties2Object((Properties)properties, (Object)containerConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
            }
            MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)containerConfig);
            if (null == containerConfig.getRocketmqHome()) {
                System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation", "ROCKETMQ_HOME");
                System.exit(-2);
            }
            rocketmqHome = containerConfig.getRocketmqHome();
            String namesrvAddr = containerConfig.getNamesrvAddr();
            if (null != namesrvAddr) {
                try {
                    String[] addrArray;
                    for (String addr : addrArray = namesrvAddr.split(";")) {
                        RemotingUtil.string2SocketAddress((String)addr);
                    }
                }
                catch (Exception e) {
                    System.out.printf("The Name Server Address[%s] illegal, please set it as follows, \"127.0.0.1:9876;192.168.0.1:9876\"%n", namesrvAddr);
                    System.exit(-3);
                }
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            CONFIGURATOR.setContext((Context)lc);
            lc.reset();
            lc.setPackagingDataEnabled(false);
            CONFIGURATOR.doConfigure(rocketmqHome + "/conf/logback_broker.xml");
            if (commandLine.hasOption(PRINT_PROPERTIES_OPTION)) {
                console = InternalLoggerFactory.getLogger((String)"RocketmqConsole");
                MixAll.printObjectProperties((InternalLogger)console, (Object)containerConfig);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyServerConfig);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyClientConfig);
                System.exit(0);
            } else if (commandLine.hasOption(PRINT_IMPORTANT_PROPERTIES_OPTION)) {
                console = InternalLoggerFactory.getLogger((String)"RocketmqConsole");
                MixAll.printObjectProperties((InternalLogger)console, (Object)containerConfig, (boolean)true);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyServerConfig, (boolean)true);
                MixAll.printObjectProperties((InternalLogger)console, (Object)nettyClientConfig, (boolean)true);
                System.exit(0);
            }
            log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
            MixAll.printObjectProperties((InternalLogger)log, (Object)containerConfig);
            MixAll.printObjectProperties((InternalLogger)log, (Object)nettyServerConfig);
            MixAll.printObjectProperties((InternalLogger)log, (Object)nettyClientConfig);
            final BrokerContainer brokerContainer = new BrokerContainer(containerConfig, nettyServerConfig, nettyClientConfig);
            brokerContainer.getConfiguration().registerConfig(properties);
            boolean initResult = brokerContainer.initialize();
            if (!initResult) {
                brokerContainer.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;
                private AtomicInteger shutdownTimes = new AtomicInteger(0);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        log.info("Shutdown hook was invoked, {}", (Object)this.shutdownTimes.incrementAndGet());
                        if (!this.hasShutdown) {
                            this.hasShutdown = true;
                            long beginTime = System.currentTimeMillis();
                            brokerContainer.shutdown();
                            long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                            log.info("Shutdown hook over, consuming total time(ms): {}", (Object)consumingTimeTotal);
                        }
                    }
                }
            }, "ShutdownHook"));
            return brokerContainer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private static void properties2SystemEnv(Properties properties) {
        if (properties == null) {
            return;
        }
        String rmqAddressServerDomain = properties.getProperty("rmqAddressServerDomain", MixAll.WS_DOMAIN_NAME);
        String rmqAddressServerSubGroup = properties.getProperty("rmqAddressServerSubGroup", MixAll.WS_DOMAIN_SUBGROUP);
        System.setProperty("rocketmq.namesrv.domain", rmqAddressServerDomain);
        System.setProperty("rocketmq.namesrv.domain.subgroup", rmqAddressServerSubGroup);
    }

    private static Options buildCommandlineOptions(Options options) {
        Option opt = new Option(BROKER_CONTAINER_CONFIG_OPTION, "configFile", true, "Config file for shared broker");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option(PRINT_PROPERTIES_OPTION, "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option(PRINT_IMPORTANT_PROPERTIES_OPTION, "printImportantConfig", false, "Print important config item");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option(BROKER_CONFIG_OPTION, "brokerConfigFiles", true, "The path of broker config files, split by ':'");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    static {
        CONFIG_FILE_HELPER = new SystemConfigFileHelper();
        rocketmqHome = null;
        CONFIGURATOR = new JoranConfigurator();
    }

    public static class SystemConfigFileHelper {
        private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigFileHelper.class);
        private String file;

        public Properties loadConfig() throws Exception {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            Properties properties = new Properties();
            properties.load(in);
            ((InputStream)in).close();
            return properties;
        }

        public void update(Properties properties) throws Exception {
            LOGGER.error("[SystemConfigFileHelper] update no thing.");
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

