/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.EpochEntry;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.ha.FlowMonitor;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnectionState;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.ha.autoswitch.EpochFileCache;
import org.apache.rocketmq.store.ha.io.AbstractHAReader;
import org.apache.rocketmq.store.ha.io.HAWriter;

public class AutoSwitchHAClient
extends ServiceThread
implements HAClient {
    public static final int HANDSHAKE_HEADER_SIZE = 12;
    public static final int HANDSHAKE_SIZE = 62;
    public static final int TRANSFER_HEADER_SIZE = 12;
    public static final int MIN_HEADER_SIZE = Math.min(12, 12);
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    private static final int READ_MAX_BUFFER_SIZE = 0x400000;
    private final AtomicReference<String> masterHaAddress = new AtomicReference();
    private final AtomicReference<String> masterAddress = new AtomicReference();
    private final AtomicReference<Long> slaveId = new AtomicReference();
    private final ByteBuffer handshakeHeaderBuffer = ByteBuffer.allocate(62);
    private final ByteBuffer transferHeaderBuffer = ByteBuffer.allocate(12);
    private final AutoSwitchHAService haService;
    private final ByteBuffer byteBufferRead = ByteBuffer.allocate(0x400000);
    private final DefaultMessageStore messageStore;
    private final EpochFileCache epochCache;
    private String localAddress;
    private SocketChannel socketChannel;
    private Selector selector;
    private AbstractHAReader haReader;
    private HAWriter haWriter;
    private FlowMonitor flowMonitor;
    private long lastReadTimestamp;
    private long lastWriteTimestamp;
    private long currentReportedOffset;
    private int processPosition;
    private volatile HAConnectionState currentState;
    private volatile long currentReceivedEpoch;

    public AutoSwitchHAClient(AutoSwitchHAService haService, DefaultMessageStore defaultMessageStore, EpochFileCache epochCache) throws IOException {
        this.haService = haService;
        this.messageStore = defaultMessageStore;
        this.epochCache = epochCache;
        this.init();
    }

    public void init() throws IOException {
        this.selector = RemotingUtil.openSelector();
        this.flowMonitor = new FlowMonitor(this.messageStore.getMessageStoreConfig());
        this.haReader = new HAClientReader();
        this.haReader.registerHook(readSize -> {
            if (readSize > 0) {
                this.flowMonitor.addByteCountTransferred(readSize);
                this.lastReadTimestamp = System.currentTimeMillis();
            }
        });
        this.haWriter = new HAWriter();
        this.haWriter.registerHook(writeSize -> {
            if (writeSize > 0) {
                this.lastWriteTimestamp = System.currentTimeMillis();
            }
        });
        this.changeCurrentState(HAConnectionState.READY);
        this.currentReceivedEpoch = -1L;
        this.currentReportedOffset = 0L;
        this.processPosition = 0;
        this.lastReadTimestamp = System.currentTimeMillis();
        this.lastWriteTimestamp = System.currentTimeMillis();
        this.haService.updateConfirmOffset(-1L);
    }

    public void reOpen() throws IOException {
        this.shutdown();
        this.init();
    }

    public String getServiceName() {
        if (this.haService.getDefaultMessageStore().getBrokerConfig().isInBrokerContainer()) {
            return this.haService.getDefaultMessageStore().getBrokerIdentity().getLoggerIdentifier() + AutoSwitchHAClient.class.getSimpleName();
        }
        return AutoSwitchHAClient.class.getSimpleName();
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void updateSlaveId(Long newId) {
        Long currentId = this.slaveId.get();
        if (this.slaveId.compareAndSet(currentId, newId)) {
            LOGGER.info("Update slave Id, OLD: {}, New: {}", (Object)currentId, (Object)newId);
        }
    }

    @Override
    public void updateMasterAddress(String newAddress) {
        String currentAddr = this.masterAddress.get();
        if (!StringUtils.equals((CharSequence)newAddress, (CharSequence)currentAddr) && this.masterAddress.compareAndSet(currentAddr, newAddress)) {
            LOGGER.info("update master address, OLD: " + currentAddr + " NEW: " + newAddress);
        }
    }

    @Override
    public void updateHaMasterAddress(String newAddress) {
        String currentAddr = this.masterHaAddress.get();
        if (!StringUtils.equals((CharSequence)newAddress, (CharSequence)currentAddr) && this.masterHaAddress.compareAndSet(currentAddr, newAddress)) {
            LOGGER.info("update master ha address, OLD: " + currentAddr + " NEW: " + newAddress);
            this.wakeup();
        }
    }

    @Override
    public String getMasterAddress() {
        return this.masterAddress.get();
    }

    @Override
    public String getHaMasterAddress() {
        return this.masterHaAddress.get();
    }

    @Override
    public long getLastReadTimestamp() {
        return this.lastReadTimestamp;
    }

    @Override
    public long getLastWriteTimestamp() {
        return this.lastWriteTimestamp;
    }

    @Override
    public HAConnectionState getCurrentState() {
        return this.currentState;
    }

    @Override
    public void changeCurrentState(HAConnectionState haConnectionState) {
        LOGGER.info("change state to {}", (Object)haConnectionState);
        this.currentState = haConnectionState;
    }

    public void closeMasterAndWait() {
        this.closeMaster();
        this.waitForRunning(5000L);
    }

    @Override
    public void closeMaster() {
        if (null != this.socketChannel) {
            try {
                SelectionKey sk = this.socketChannel.keyFor(this.selector);
                if (sk != null) {
                    sk.cancel();
                }
                this.socketChannel.close();
                this.socketChannel = null;
                LOGGER.info("AutoSwitchHAClient close connection with master {}", (Object)this.masterHaAddress.get());
                this.changeCurrentState(HAConnectionState.READY);
            }
            catch (IOException e) {
                LOGGER.warn("CloseMaster exception. ", (Throwable)e);
            }
            this.lastReadTimestamp = 0L;
            this.processPosition = 0;
            this.byteBufferRead.position(0);
            this.byteBufferRead.limit(0x400000);
        }
    }

    @Override
    public long getTransferredByteInSecond() {
        return this.flowMonitor.getTransferredByteInSecond();
    }

    @Override
    public void shutdown() {
        this.changeCurrentState(HAConnectionState.SHUTDOWN);
        this.flowMonitor.shutdown();
        super.shutdown();
        this.closeMaster();
        try {
            this.selector.close();
        }
        catch (IOException e) {
            LOGGER.warn("Close the selector of AutoSwitchHAClient error, ", (Throwable)e);
        }
    }

    private boolean isTimeToReportOffset() {
        long interval = this.messageStore.now() - this.lastWriteTimestamp;
        return interval > (long)this.messageStore.getMessageStoreConfig().getHaSendHeartbeatInterval();
    }

    private boolean sendHandshakeHeader() throws IOException {
        this.handshakeHeaderBuffer.position(0);
        this.handshakeHeaderBuffer.limit(62);
        this.handshakeHeaderBuffer.putInt(HAConnectionState.HANDSHAKE.ordinal());
        short isSyncFromLastFile = this.haService.getDefaultMessageStore().getMessageStoreConfig().isSyncFromLastFile() ? (short)1 : 0;
        this.handshakeHeaderBuffer.putShort(isSyncFromLastFile);
        short isAsyncLearner = this.haService.getDefaultMessageStore().getMessageStoreConfig().isAsyncLearner() ? (short)1 : 0;
        this.handshakeHeaderBuffer.putShort(isAsyncLearner);
        this.handshakeHeaderBuffer.putInt(this.localAddress == null ? 0 : this.localAddress.length());
        this.handshakeHeaderBuffer.put(this.localAddress == null ? new byte[]{} : this.localAddress.getBytes(StandardCharsets.UTF_8));
        this.handshakeHeaderBuffer.flip();
        return this.haWriter.write(this.socketChannel, this.handshakeHeaderBuffer);
    }

    private void handshakeWithMaster() throws IOException {
        boolean result = this.sendHandshakeHeader();
        if (!result) {
            this.closeMasterAndWait();
        }
        this.selector.select(5000L);
        result = this.haReader.read(this.socketChannel, this.byteBufferRead);
        if (!result) {
            this.closeMasterAndWait();
        }
    }

    private boolean reportSlaveOffset(long offsetToReport) throws IOException {
        this.transferHeaderBuffer.position(0);
        this.transferHeaderBuffer.limit(12);
        this.transferHeaderBuffer.putInt(this.currentState.ordinal());
        this.transferHeaderBuffer.putLong(offsetToReport);
        this.transferHeaderBuffer.flip();
        return this.haWriter.write(this.socketChannel, this.transferHeaderBuffer);
    }

    private boolean reportSlaveMaxOffset() throws IOException {
        boolean result = true;
        long maxPhyOffset = this.messageStore.getMaxPhyOffset();
        if (maxPhyOffset > this.currentReportedOffset) {
            this.currentReportedOffset = maxPhyOffset;
            result = this.reportSlaveOffset(this.currentReportedOffset);
        }
        return result;
    }

    public boolean connectMaster() throws IOException {
        if (null == this.socketChannel) {
            String addr = this.masterHaAddress.get();
            if (StringUtils.isNotEmpty((CharSequence)addr)) {
                SocketAddress socketAddress = RemotingUtil.string2SocketAddress((String)addr);
                this.socketChannel = RemotingUtil.connect((SocketAddress)socketAddress);
                if (this.socketChannel != null) {
                    this.socketChannel.register(this.selector, 1);
                    LOGGER.info("AutoSwitchHAClient connect to master {}", (Object)addr);
                    this.changeCurrentState(HAConnectionState.HANDSHAKE);
                }
            }
            this.currentReportedOffset = this.messageStore.getMaxPhyOffset();
            this.lastReadTimestamp = System.currentTimeMillis();
        }
        return this.socketChannel != null;
    }

    private boolean transferFromMaster() throws IOException {
        boolean result;
        if (this.isTimeToReportOffset()) {
            LOGGER.info("Slave report current offset {}", (Object)this.currentReportedOffset);
            result = this.reportSlaveOffset(this.currentReportedOffset);
            if (!result) {
                return false;
            }
        }
        this.selector.select(1000L);
        result = this.haReader.read(this.socketChannel, this.byteBufferRead);
        if (!result) {
            return false;
        }
        return this.reportSlaveMaxOffset();
    }

    public void run() {
        LOGGER.info(this.getServiceName() + " service started");
        this.flowMonitor.start();
        block8: while (!this.isStopped()) {
            try {
                switch (this.currentState) {
                    case SHUTDOWN: {
                        return;
                    }
                    case READY: {
                        long truncateOffset = this.haService.truncateInvalidMsg();
                        if (truncateOffset >= 0L) {
                            this.epochCache.truncateSuffixByOffset(truncateOffset);
                        }
                        if (this.connectMaster()) continue block8;
                        LOGGER.warn("AutoSwitchHAClient connect to master {} failed", (Object)this.masterHaAddress.get());
                        this.waitForRunning(5000L);
                        continue block8;
                    }
                    case HANDSHAKE: {
                        this.handshakeWithMaster();
                        continue block8;
                    }
                    case TRANSFER: {
                        if (this.transferFromMaster()) break;
                        this.closeMasterAndWait();
                        continue block8;
                    }
                    default: {
                        this.waitForRunning(5000L);
                        continue block8;
                    }
                }
                long interval = this.messageStore.now() - this.lastReadTimestamp;
                if (interval <= (long)this.messageStore.getMessageStoreConfig().getHaHousekeepingInterval()) continue;
                LOGGER.warn("AutoSwitchHAClient, housekeeping, found this connection[" + this.masterHaAddress + "] expired, " + interval);
                this.closeMaster();
                LOGGER.warn("AutoSwitchHAClient, master not response some time, so close connection");
            }
            catch (Exception e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                this.closeMasterAndWait();
            }
        }
    }

    private boolean doTruncate(List<EpochEntry> masterEpochEntries, long masterEndOffset) throws IOException {
        if (this.epochCache.getEntrySize() == 0) {
            LOGGER.info("Slave local epochCache is empty, skip truncate log");
            this.changeCurrentState(HAConnectionState.TRANSFER);
            this.currentReportedOffset = 0L;
        } else {
            EpochFileCache masterEpochCache = new EpochFileCache();
            masterEpochCache.initCacheFromEntries(masterEpochEntries);
            masterEpochCache.setLastEpochEntryEndOffset(masterEndOffset);
            List<EpochEntry> localEpochEntries = this.epochCache.getAllEntries();
            EpochFileCache localEpochCache = new EpochFileCache();
            localEpochCache.initCacheFromEntries(localEpochEntries);
            localEpochCache.setLastEpochEntryEndOffset(this.messageStore.getMaxPhyOffset());
            long truncateOffset = localEpochCache.findConsistentPoint(masterEpochCache);
            if (truncateOffset < 0L) {
                LOGGER.error("Failed to find a consistent point between masterEpoch:{} and slaveEpoch:{}", masterEpochEntries, localEpochEntries);
                return false;
            }
            if (!this.messageStore.truncateFiles(truncateOffset)) {
                LOGGER.error("Failed to truncate slave log to {}", (Object)truncateOffset);
                return false;
            }
            this.epochCache.truncateSuffixByOffset(truncateOffset);
            LOGGER.info("Truncate slave log to {} success, change to transfer state", (Object)truncateOffset);
            this.changeCurrentState(HAConnectionState.TRANSFER);
            this.currentReportedOffset = truncateOffset;
        }
        if (!this.reportSlaveMaxOffset()) {
            LOGGER.error("AutoSwitchHAClient report max offset to master failed");
            return false;
        }
        return true;
    }

    class HAClientReader
    extends AbstractHAReader {
        HAClientReader() {
        }

        @Override
        protected boolean processReadResult(ByteBuffer byteBufferRead) {
            int readSocketPos = byteBufferRead.position();
            try {
                int diff;
                block6: while ((diff = byteBufferRead.position() - AutoSwitchHAClient.this.processPosition) >= 36) {
                    int processPosition = AutoSwitchHAClient.this.processPosition;
                    int masterState = byteBufferRead.getInt(processPosition + 36 - 36);
                    int bodySize = byteBufferRead.getInt(processPosition + 36 - 32);
                    long masterOffset = byteBufferRead.getLong(processPosition + 36 - 28);
                    int masterEpoch = byteBufferRead.getInt(processPosition + 36 - 20);
                    long masterEpochStartOffset = byteBufferRead.getLong(processPosition + 36 - 16);
                    long confirmOffset = byteBufferRead.getLong(processPosition + 36 - 8);
                    if (masterState != AutoSwitchHAClient.this.currentState.ordinal()) {
                        AutoSwitchHAClient autoSwitchHAClient = AutoSwitchHAClient.this;
                        autoSwitchHAClient.processPosition = autoSwitchHAClient.processPosition + (36 + bodySize);
                        AutoSwitchHAClient.this.waitForRunning(1L);
                        LOGGER.error("State not matched, masterState:{}, slaveState:{}, bodySize:{}, offset:{}, masterEpoch:{}, masterEpochStartOffset:{}, confirmOffset:{}", new Object[]{masterState, AutoSwitchHAClient.this.currentState, bodySize, masterOffset, masterEpoch, masterEpochStartOffset, confirmOffset});
                        return true;
                    }
                    if (diff < 36 + bodySize) break;
                    switch (AutoSwitchHAClient.this.currentState) {
                        case HANDSHAKE: {
                            AutoSwitchHAClient autoSwitchHAClient = AutoSwitchHAClient.this;
                            autoSwitchHAClient.processPosition = autoSwitchHAClient.processPosition + 36;
                            int entrySize = 12;
                            int entryNums = bodySize / entrySize;
                            ArrayList<EpochEntry> epochEntries = new ArrayList<EpochEntry>(entryNums);
                            for (int i = 0; i < entryNums; ++i) {
                                int epoch = byteBufferRead.getInt(AutoSwitchHAClient.this.processPosition + i * entrySize);
                                long startOffset = byteBufferRead.getLong(AutoSwitchHAClient.this.processPosition + i * entrySize + 4);
                                epochEntries.add(new EpochEntry(epoch, startOffset));
                            }
                            byteBufferRead.position(readSocketPos);
                            AutoSwitchHAClient i = AutoSwitchHAClient.this;
                            i.processPosition = i.processPosition + bodySize;
                            LOGGER.info("Receive handshake, masterMaxPosition {}, masterEpochEntries:{}, try truncate log", (Object)masterOffset, epochEntries);
                            if (AutoSwitchHAClient.this.doTruncate(epochEntries, masterOffset)) continue block6;
                            AutoSwitchHAClient.this.waitForRunning(2000L);
                            LOGGER.error("AutoSwitchHAClient truncate log failed in handshake state");
                            return false;
                        }
                        case TRANSFER: {
                            byte[] bodyData = new byte[bodySize];
                            byteBufferRead.position(AutoSwitchHAClient.this.processPosition + 36);
                            byteBufferRead.get(bodyData);
                            byteBufferRead.position(readSocketPos);
                            AutoSwitchHAClient epoch = AutoSwitchHAClient.this;
                            epoch.processPosition = epoch.processPosition + (36 + bodySize);
                            long slavePhyOffset = AutoSwitchHAClient.this.messageStore.getMaxPhyOffset();
                            if (slavePhyOffset != 0L && slavePhyOffset != masterOffset) {
                                LOGGER.error("master pushed offset not equal the max phy offset in slave, SLAVE: " + slavePhyOffset + " MASTER: " + masterOffset);
                                return false;
                            }
                            if ((long)masterEpoch != AutoSwitchHAClient.this.currentReceivedEpoch) {
                                AutoSwitchHAClient.this.currentReceivedEpoch = masterEpoch;
                                AutoSwitchHAClient.this.epochCache.appendEntry(new EpochEntry(masterEpoch, masterEpochStartOffset));
                            }
                            if (bodySize > 0) {
                                AutoSwitchHAClient.this.messageStore.appendToCommitLog(masterOffset, bodyData, 0, bodyData.length);
                            }
                            AutoSwitchHAClient.this.haService.updateConfirmOffset(Math.min(confirmOffset, AutoSwitchHAClient.this.messageStore.getMaxPhyOffset()));
                            if (AutoSwitchHAClient.this.reportSlaveMaxOffset()) continue block6;
                            LOGGER.error("AutoSwitchHAClient report max offset to master failed");
                            return false;
                        }
                    }
                }
                if (!byteBufferRead.hasRemaining()) {
                    byteBufferRead.position(AutoSwitchHAClient.this.processPosition);
                    byteBufferRead.compact();
                    AutoSwitchHAClient.this.processPosition = 0;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error when ha client process read request", (Throwable)e);
            }
            return true;
        }
    }
}

