/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;
import org.slf4j.LoggerFactory;

public class ControllerStartup {
    private static InternalLogger log;
    private static Properties properties;
    private static CommandLine commandLine;

    public static void main(String[] args) {
        ControllerStartup.main0(args);
    }

    public static ControllerManager main0(String[] args) {
        try {
            ControllerManager controller = ControllerStartup.createControllerManager(args);
            ControllerStartup.start(controller);
            String tip = "The Controller Server boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
            log.info(tip);
            System.out.printf("%s%n", tip);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static ControllerManager createControllerManager(String[] args) throws IOException, JoranException {
        String file;
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        commandLine = ServerUtil.parseCmdLine((String)"mqcontroller", (String[])args, (Options)ControllerStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
        if (null == commandLine) {
            System.exit(-1);
            return null;
        }
        ControllerConfig controllerConfig = new ControllerConfig();
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        nettyServerConfig.setListenPort(19876);
        if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            properties = new Properties();
            properties.load(in);
            MixAll.properties2Object((Properties)properties, (Object)controllerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
            System.out.printf("load config properties file OK, %s%n", file);
            ((InputStream)in).close();
        }
        if (commandLine.hasOption('p')) {
            MixAll.printObjectProperties(null, (Object)controllerConfig);
            MixAll.printObjectProperties(null, (Object)nettyServerConfig);
            MixAll.printObjectProperties(null, (Object)nettyClientConfig);
            System.exit(0);
        }
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)controllerConfig);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        if (StringUtils.isEmpty((CharSequence)controllerConfig.getRocketmqHome())) {
            System.out.printf("Please set the %s or %s variable in your environment!%n", "ROCKETMQ_HOME", "rocketmq.home.dir");
            System.exit(-1);
        }
        configurator.doConfigure(controllerConfig.getRocketmqHome() + "/conf/logback_controller.xml");
        log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");
        MixAll.printObjectProperties((InternalLogger)log, (Object)controllerConfig);
        MixAll.printObjectProperties((InternalLogger)log, (Object)nettyServerConfig);
        ControllerManager controllerManager = new ControllerManager(controllerConfig, nettyServerConfig, nettyClientConfig);
        controllerManager.getConfiguration().registerConfig(properties);
        return controllerManager;
    }

    public static ControllerManager start(ControllerManager controller) throws Exception {
        if (null == controller) {
            throw new IllegalArgumentException("ControllerManager is null");
        }
        boolean initResult = controller.initialize();
        if (!initResult) {
            controller.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, () -> {
            controller.shutdown();
            return null;
        }));
        controller.start();
        return controller;
    }

    public static void shutdown(ControllerManager controller) {
        controller.shutdown();
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Controller config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config items");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    static {
        properties = null;
        commandLine = null;
    }
}

