/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class GetMessageResult {
    private final List<SelectMappedBufferResult> messageMapedList;
    private final List<ByteBuffer> messageBufferList;
    private final List<Long> messageQueueOffset;
    private GetMessageStatus status;
    private long nextBeginOffset;
    private long minOffset;
    private long maxOffset;
    private int bufferTotalSize = 0;
    private int messageCount = 0;
    private boolean suggestPullingFromSlave = false;
    private int msgCount4Commercial = 0;
    private int commercialSizePerMsg = 4096;
    public static final GetMessageResult NO_MATCH_LOGIC_QUEUE = new GetMessageResult(GetMessageStatus.NO_MATCHED_LOGIC_QUEUE, 0L, 0L, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public GetMessageResult() {
        this.messageMapedList = new ArrayList<SelectMappedBufferResult>(100);
        this.messageBufferList = new ArrayList<ByteBuffer>(100);
        this.messageQueueOffset = new ArrayList<Long>(100);
    }

    public GetMessageResult(int resultSize) {
        this.messageMapedList = new ArrayList<SelectMappedBufferResult>(resultSize);
        this.messageBufferList = new ArrayList<ByteBuffer>(resultSize);
        this.messageQueueOffset = new ArrayList<Long>(resultSize);
    }

    private GetMessageResult(GetMessageStatus status, long nextBeginOffset, long minOffset, long maxOffset, List<SelectMappedBufferResult> messageMapedList, List<ByteBuffer> messageBufferList, List<Long> messageQueueOffset) {
        this.status = status;
        this.nextBeginOffset = nextBeginOffset;
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.messageMapedList = messageMapedList;
        this.messageBufferList = messageBufferList;
        this.messageQueueOffset = messageQueueOffset;
    }

    public GetMessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(GetMessageStatus status) {
        this.status = status;
    }

    public long getNextBeginOffset() {
        return this.nextBeginOffset;
    }

    public void setNextBeginOffset(long nextBeginOffset) {
        this.nextBeginOffset = nextBeginOffset;
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public void setMinOffset(long minOffset) {
        this.minOffset = minOffset;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }

    public void setMaxOffset(long maxOffset) {
        this.maxOffset = maxOffset;
    }

    public List<SelectMappedBufferResult> getMessageMapedList() {
        return this.messageMapedList;
    }

    public List<ByteBuffer> getMessageBufferList() {
        return this.messageBufferList;
    }

    public void addMessage(SelectMappedBufferResult mapedBuffer) {
        this.messageMapedList.add(mapedBuffer);
        this.messageBufferList.add(mapedBuffer.getByteBuffer());
        this.bufferTotalSize += mapedBuffer.getSize();
        this.msgCount4Commercial += (int)Math.ceil((double)mapedBuffer.getSize() / (double)this.commercialSizePerMsg);
        ++this.messageCount;
    }

    public void addMessage(SelectMappedBufferResult mapedBuffer, long queueOffset) {
        this.messageMapedList.add(mapedBuffer);
        this.messageBufferList.add(mapedBuffer.getByteBuffer());
        this.bufferTotalSize += mapedBuffer.getSize();
        this.msgCount4Commercial += (int)Math.ceil((double)mapedBuffer.getSize() / (double)this.commercialSizePerMsg);
        ++this.messageCount;
        this.messageQueueOffset.add(queueOffset);
    }

    public void addMessage(SelectMappedBufferResult mapedBuffer, long queueOffset, int batchNum) {
        this.addMessage(mapedBuffer, queueOffset);
        this.messageCount += batchNum - 1;
    }

    public void release() {
        for (SelectMappedBufferResult select : this.messageMapedList) {
            select.release();
        }
    }

    public int getBufferTotalSize() {
        return this.bufferTotalSize;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public boolean isSuggestPullingFromSlave() {
        return this.suggestPullingFromSlave;
    }

    public void setSuggestPullingFromSlave(boolean suggestPullingFromSlave) {
        this.suggestPullingFromSlave = suggestPullingFromSlave;
    }

    public int getMsgCount4Commercial() {
        return this.msgCount4Commercial;
    }

    public void setMsgCount4Commercial(int msgCount4Commercial) {
        this.msgCount4Commercial = msgCount4Commercial;
    }

    public List<Long> getMessageQueueOffset() {
        return this.messageQueueOffset;
    }

    public String toString() {
        return "GetMessageResult [status=" + (Object)((Object)this.status) + ", nextBeginOffset=" + this.nextBeginOffset + ", minOffset=" + this.minOffset + ", maxOffset=" + this.maxOffset + ", bufferTotalSize=" + this.bufferTotalSize + ", messageCount=" + this.messageCount + ", suggestPullingFromSlave=" + this.suggestPullingFromSlave + "]";
    }
}

