/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.Server;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class GrpcServer
implements StartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final Server server;

    protected GrpcServer(Server server) {
        this.server = server;
    }

    public void start() throws Exception {
        this.server.start();
        log.info("grpc server start successfully.");
    }

    public void shutdown() {
        try {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
            log.info("grpc server shutdown successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

