/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.common.config.ConfigHelper;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class ConfigRocksDBStorage
extends AbstractRocksDBStorage {
    public static final byte[] KV_DATA_VERSION_COLUMN_FAMILY_NAME = "kvDataVersion".getBytes(StandardCharsets.UTF_8);
    public static final byte[] FORBIDDEN_COLUMN_FAMILY_NAME = "forbidden".getBytes(StandardCharsets.UTF_8);
    protected ColumnFamilyHandle kvDataVersionFamilyHandle;
    protected ColumnFamilyHandle forbiddenFamilyHandle;
    public static final byte[] KV_DATA_VERSION_KEY = "kvDataVersionKey".getBytes(StandardCharsets.UTF_8);

    public ConfigRocksDBStorage(String dbPath) {
        this(dbPath, false);
    }

    public ConfigRocksDBStorage(String dbPath, CompressionType compressionType) {
        this(dbPath, false);
        this.compressionType = compressionType;
    }

    public ConfigRocksDBStorage(String dbPath, boolean readOnly) {
        super(dbPath);
        this.readOnly = readOnly;
    }

    @Override
    protected void initOptions() {
        this.options = ConfigHelper.createConfigDBOptions();
        super.initOptions();
    }

    @Override
    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK(this.dbPath);
            this.initOptions();
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            ColumnFamilyOptions defaultOptions = ConfigHelper.createConfigColumnFamilyOptions();
            this.cfOptions.add(defaultOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, defaultOptions));
            cfDescriptors.add(new ColumnFamilyDescriptor(KV_DATA_VERSION_COLUMN_FAMILY_NAME, defaultOptions));
            cfDescriptors.add(new ColumnFamilyDescriptor(FORBIDDEN_COLUMN_FAMILY_NAME, defaultOptions));
            this.open(cfDescriptors);
            this.defaultCFHandle = (ColumnFamilyHandle)this.cfHandles.get(0);
            this.kvDataVersionFamilyHandle = (ColumnFamilyHandle)this.cfHandles.get(1);
            this.forbiddenFamilyHandle = (ColumnFamilyHandle)this.cfHandles.get(2);
        }
        catch (Exception e) {
            AbstractRocksDBStorage.LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    protected void preShutdown() {
        this.kvDataVersionFamilyHandle.close();
        this.forbiddenFamilyHandle.close();
    }

    public void put(byte[] keyBytes, int keyLen, byte[] valueBytes) throws Exception {
        this.put(this.defaultCFHandle, this.ableWalWriteOptions, keyBytes, keyLen, valueBytes, valueBytes.length);
    }

    public void put(ByteBuffer keyBB, ByteBuffer valueBB) throws Exception {
        this.put(this.defaultCFHandle, this.ableWalWriteOptions, keyBB, valueBB);
    }

    public byte[] get(byte[] keyBytes) throws Exception {
        return this.get(this.defaultCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public void updateKvDataVersion(byte[] valueBytes) throws Exception {
        this.put(this.kvDataVersionFamilyHandle, this.ableWalWriteOptions, KV_DATA_VERSION_KEY, KV_DATA_VERSION_KEY.length, valueBytes, valueBytes.length);
    }

    public byte[] getKvDataVersion() throws Exception {
        return this.get(this.kvDataVersionFamilyHandle, this.totalOrderReadOptions, KV_DATA_VERSION_KEY);
    }

    public void updateForbidden(byte[] keyBytes, byte[] valueBytes) throws Exception {
        this.put(this.forbiddenFamilyHandle, this.ableWalWriteOptions, keyBytes, keyBytes.length, valueBytes, valueBytes.length);
    }

    public byte[] getForbidden(byte[] keyBytes) throws Exception {
        return this.get(this.forbiddenFamilyHandle, this.totalOrderReadOptions, keyBytes);
    }

    public void delete(byte[] keyBytes) throws Exception {
        this.delete(this.defaultCFHandle, this.ableWalWriteOptions, keyBytes);
    }

    public List<byte[]> multiGet(List<ColumnFamilyHandle> cfhList, List<byte[]> keys) throws RocksDBException {
        return this.multiGet(this.totalOrderReadOptions, cfhList, keys);
    }

    public void batchPut(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.writeOptions, batch);
    }

    public void batchPutWithWal(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.ableWalWriteOptions, batch);
    }

    public RocksIterator iterator() {
        return this.db.newIterator(this.defaultCFHandle, this.totalOrderReadOptions);
    }

    public RocksIterator forbiddenIterator() {
        return this.db.newIterator(this.forbiddenFamilyHandle, this.totalOrderReadOptions);
    }

    public RocksIterator iterator(ReadOptions readOptions) {
        return this.db.newIterator(this.defaultCFHandle, readOptions);
    }
}

