/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import java.time.Duration;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;

public class ClientConfigurationBuilder {
    private String endpoints;
    private SessionCredentialsProvider sessionCredentialsProvider = null;
    private Duration requestTimeout = Duration.ofSeconds(3L);
    private boolean sslEnabled = true;
    private String namespace = "";
    private int maxStartupAttempts = 3;

    public ClientConfigurationBuilder setEndpoints(String endpoints) {
        Preconditions.checkNotNull(endpoints, "endpoints should not be null");
        this.endpoints = endpoints;
        return this;
    }

    public ClientConfigurationBuilder setCredentialProvider(SessionCredentialsProvider sessionCredentialsProvider) {
        this.sessionCredentialsProvider = Preconditions.checkNotNull(sessionCredentialsProvider, "credentialsProvider should not be null");
        return this;
    }

    public ClientConfigurationBuilder setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = Preconditions.checkNotNull(requestTimeout, "requestTimeout should not be null");
        return this;
    }

    public ClientConfigurationBuilder enableSsl(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public ClientConfigurationBuilder setNamespace(String namespace) {
        this.namespace = Preconditions.checkNotNull(namespace, "namespace should not be null");
        return this;
    }

    public ClientConfigurationBuilder setMaxStartupAttempts(int maxStartupAttempts) {
        Preconditions.checkArgument(maxStartupAttempts > 0, "maxStartupAttempts should more than 0");
        this.maxStartupAttempts = maxStartupAttempts;
        return this;
    }

    public ClientConfiguration build() {
        Preconditions.checkNotNull(this.endpoints, "endpoints should not be null");
        Preconditions.checkNotNull(this.requestTimeout, "requestTimeout should not be null");
        return new ClientConfiguration(this.endpoints, this.sessionCredentialsProvider, this.requestTimeout, this.sslEnabled, this.namespace, this.maxStartupAttempts);
    }
}

