/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class UrlMatcher {
    private final Object rawSource;
    private final Predicate<String> predicate;

    private static Predicate<String> toPredicate(Pattern pattern) {
        return s -> pattern.matcher((CharSequence)s).find();
    }

    static UrlMatcher any() {
        return new UrlMatcher((Object)null, null);
    }

    static UrlMatcher forOneOf(URL baseUrl, Object object) {
        if (object == null) {
            return UrlMatcher.any();
        }
        if (object instanceof String) {
            return new UrlMatcher(baseUrl, (String)object);
        }
        if (object instanceof Pattern) {
            return new UrlMatcher((Pattern)object);
        }
        if (object instanceof Predicate) {
            return new UrlMatcher((Predicate)object);
        }
        throw new PlaywrightException("Url must be String, Pattern or Predicate<String>, found: " + object.getClass().getTypeName());
    }

    static String resolveUrl(URL baseUrl, String spec) {
        if (baseUrl == null) {
            return spec;
        }
        try {
            return new URL(baseUrl, spec).toString();
        }
        catch (MalformedURLException e) {
            return spec;
        }
    }

    UrlMatcher(URL base, String url) {
        this(url, UrlMatcher.toPredicate(Pattern.compile(Utils.globToRegex(UrlMatcher.resolveUrl(base, url)))).or(s -> url == null || url.equals(s)));
    }

    UrlMatcher(Pattern pattern) {
        this(pattern, UrlMatcher.toPredicate(pattern));
    }

    UrlMatcher(Predicate<String> predicate) {
        this(predicate, predicate);
    }

    private UrlMatcher(Object rawSource, Predicate<String> predicate) {
        this.rawSource = rawSource;
        this.predicate = predicate;
    }

    boolean test(String value) {
        return this.predicate == null || this.predicate.test(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlMatcher that = (UrlMatcher)o;
        return Objects.equals(this.rawSource, that.rawSource);
    }

    public int hashCode() {
        return Objects.hash(this.rawSource);
    }
}

