/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.compiler.CompilerAPI;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.tools.ToolsConfiguration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CommandLineConfiguration
extends ToolsConfiguration {
    private String resourceModulePath;
    private List<String> fileSpecs = new ArrayList<String>();
    private List<String> resourceBundles = new LinkedList<String>();
    private VirtualFile configFile;
    private VirtualFile projector;

    @Override
    public String getTargetFile() {
        if (this.compilingResourceModule()) {
            return this.resourceModulePath;
        }
        return this.fileSpecs.size() > 0 ? this.fileSpecs.get(this.fileSpecs.size() - 1) : null;
    }

    public List<String> getFileList() {
        if (this.compilingResourceModule()) {
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(this.resourceModulePath);
            return fileList;
        }
        return this.fileSpecs;
    }

    public boolean compilingResourceModule() {
        boolean b;
        boolean bl = b = this.fileSpecs.size() == 0 && this.getIncludeResourceBundles().size() > 0;
        if (!b || this.resourceModulePath == null) {
            // empty if block
        }
        return b;
    }

    @Override
    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        super.validate(cfgbuf);
        String targetFile = this.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        VirtualFile virt = this.getVirtualFile(targetFile);
        if (virt == null && this.checkTargetFileInFileSystem()) {
            throw new ConfigurationException.IOError(targetFile);
        }
    }

    protected VirtualFile getVirtualFile(String targetFile) throws ConfigurationException {
        return CompilerAPI.getVirtualFile(targetFile);
    }

    protected boolean checkTargetFileInFileSystem() {
        return true;
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) {
        try {
            return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cfgval);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public List<String> getFileSpecs() {
        return this.fileSpecs;
    }

    public void cfgFileSpecs(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    public static ConfigurationInfo getFileSpecsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            @Override
            public boolean isGreedy() {
                return true;
            }

            @Override
            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public List<String> getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List<String> includeResourceBundles) {
        this.resourceBundles.addAll(this.toQNameString(includeResourceBundles));
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getLoadConfig() {
        return this.configFile;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cv);
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.output = Configuration.getOutputPath(val, output);
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            @Override
            public boolean isRequired() {
                return false;
            }
        };
    }

    public void cfgJsOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.output = Configuration.getOutputPath(val, output);
    }

    public static ConfigurationInfo getJsOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            @Override
            public boolean isRequired() {
                return false;
            }
        };
    }

    public VirtualFile getProjector() {
        return this.projector;
    }

    public void cfgProjector(ConfigurationValue cfgval, String path) {
        this.projector = this.getVirtualFile(path, cfgval);
    }

    public static ConfigurationInfo getProjectorInfo() {
        return new ConfigurationInfo(){

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }
}

