import { type PropType, type VNodeChild } from 'vue';
import { type ExtractPublicPropTypes, type MaybeArray } from '../../_utils';
import { type Filter, type OnUpdateValue, type Option, type OptionValue, type TransferRenderSourceLabel, type TransferRenderSourceList, type TransferRenderTargetLabel } from './interface';
export declare const transferProps: {
    readonly value: PropType<OptionValue[] | null>;
    readonly defaultValue: {
        readonly type: PropType<OptionValue[] | null>;
        readonly default: null;
    };
    readonly options: {
        readonly type: PropType<Option[]>;
        readonly default: () => never[];
    };
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly virtualScroll: BooleanConstructor;
    readonly sourceTitle: PropType<string | (() => VNodeChild)>;
    readonly selectAllText: StringConstructor;
    readonly clearText: StringConstructor;
    readonly targetTitle: PropType<string | (() => VNodeChild)>;
    readonly filterable: {
        readonly type: BooleanConstructor;
        readonly default: undefined;
    };
    readonly sourceFilterable: BooleanConstructor;
    readonly targetFilterable: BooleanConstructor;
    readonly showSelected: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly sourceFilterPlaceholder: StringConstructor;
    readonly targetFilterPlaceholder: StringConstructor;
    readonly filter: {
        readonly type: PropType<Filter>;
        readonly default: (pattern: string, option: Option) => number | true;
    };
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderSourceLabel: PropType<TransferRenderSourceLabel>;
    readonly renderTargetLabel: PropType<TransferRenderTargetLabel>;
    readonly renderSourceList: PropType<TransferRenderSourceList>;
    readonly renderTargetList: PropType<TransferRenderSourceList>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly onChange: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
};
export type TransferProps = ExtractPublicPropTypes<typeof transferProps>;
declare const _default: import("vue").DefineComponent<{
    readonly value: PropType<OptionValue[] | null>;
    readonly defaultValue: {
        readonly type: PropType<OptionValue[] | null>;
        readonly default: null;
    };
    readonly options: {
        readonly type: PropType<Option[]>;
        readonly default: () => never[];
    };
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly virtualScroll: BooleanConstructor;
    readonly sourceTitle: PropType<string | (() => VNodeChild)>;
    readonly selectAllText: StringConstructor;
    readonly clearText: StringConstructor;
    readonly targetTitle: PropType<string | (() => VNodeChild)>;
    readonly filterable: {
        readonly type: BooleanConstructor;
        readonly default: undefined;
    };
    readonly sourceFilterable: BooleanConstructor;
    readonly targetFilterable: BooleanConstructor;
    readonly showSelected: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly sourceFilterPlaceholder: StringConstructor;
    readonly targetFilterPlaceholder: StringConstructor;
    readonly filter: {
        readonly type: PropType<Filter>;
        readonly default: (pattern: string, option: Option) => number | true;
    };
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderSourceLabel: PropType<TransferRenderSourceLabel>;
    readonly renderTargetLabel: PropType<TransferRenderTargetLabel>;
    readonly renderSourceList: PropType<TransferRenderSourceList>;
    readonly renderTargetList: PropType<TransferRenderSourceList>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly onChange: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
}, {
    mergedClsPrefix: import("vue").Ref<string>;
    mergedDisabled: import("vue").ComputedRef<boolean>;
    itemSize: import("vue").ComputedRef<number>;
    isMounted: Readonly<import("vue").Ref<boolean>>;
    mergedTheme: import("vue").ComputedRef<{
        common: import("../..").ThemeCommonVars;
        self: {
            itemHeightSmall: string;
            itemHeightMedium: string;
            itemHeightLarge: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            dividerColor: string;
            borderColor: string;
            listColor: string;
            headerColor: string;
            titleTextColor: string;
            titleTextColorDisabled: string;
            extraTextColor: string;
            extraTextColorDisabled: string;
            itemTextColor: string;
            itemTextColorDisabled: string;
            itemColorPending: string;
            titleFontWeight: string;
            closeColorHover: string;
            closeColorPressed: string;
            closeIconColor: string;
            closeIconColorHover: string;
            closeIconColorPressed: string;
            extraFontSizeSmall: string;
            extraFontSizeMedium: string;
            extraFontSizeLarge: string;
            titleFontSizeSmall: string;
            titleFontSizeMedium: string;
            titleFontSizeLarge: string;
            closeSize: string;
            closeIconSize: string;
            headerHeightSmall: string;
            headerHeightMedium: string;
            headerHeightLarge: string;
        };
        peers: {
            Checkbox: import("../../_mixins").Theme<"Checkbox", {
                labelLineHeight: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                borderRadius: string;
                color: string;
                colorChecked: string;
                colorDisabled: string;
                colorDisabledChecked: string;
                colorTableHeader: string;
                colorTableHeaderModal: string;
                colorTableHeaderPopover: string;
                checkMarkColor: string;
                checkMarkColorDisabled: string;
                checkMarkColorDisabledChecked: string;
                border: string;
                borderDisabled: string;
                borderDisabledChecked: string;
                borderChecked: string;
                borderFocus: string;
                boxShadowFocus: string;
                textColor: string;
                textColorDisabled: string;
                sizeSmall: string;
                sizeMedium: string;
                sizeLarge: string;
                labelPadding: string;
                labelFontWeight: string;
            }, any>;
            Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
                height: string;
                width: string;
                borderRadius: string;
                color: string;
                colorHover: string;
                railInsetHorizontalBottom: string;
                railInsetHorizontalTop: string;
                railInsetVerticalRight: string;
                railInsetVerticalLeft: string;
                railColor: string;
            }, any>;
            Input: import("../../_mixins").Theme<"Input", {
                countTextColorDisabled: string;
                countTextColor: string;
                heightTiny: string;
                heightSmall: string;
                heightMedium: string;
                heightLarge: string;
                fontSizeTiny: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                lineHeight: string;
                lineHeightTextarea: string;
                borderRadius: string;
                iconSize: string;
                groupLabelColor: string;
                groupLabelTextColor: string;
                textColor: string;
                textColorDisabled: string;
                textDecorationColor: string;
                caretColor: string;
                placeholderColor: string;
                placeholderColorDisabled: string;
                color: string;
                colorDisabled: string;
                colorFocus: string;
                groupLabelBorder: string;
                border: string;
                borderHover: string;
                borderDisabled: string;
                borderFocus: string;
                boxShadowFocus: string;
                loadingColor: string;
                loadingColorWarning: string;
                borderWarning: string;
                borderHoverWarning: string;
                colorFocusWarning: string;
                borderFocusWarning: string;
                boxShadowFocusWarning: string;
                caretColorWarning: string;
                loadingColorError: string;
                borderError: string;
                borderHoverError: string;
                colorFocusError: string;
                borderFocusError: string;
                boxShadowFocusError: string;
                caretColorError: string;
                clearColor: string;
                clearColorHover: string;
                clearColorPressed: string;
                iconColor: string;
                iconColorDisabled: string;
                iconColorHover: string;
                iconColorPressed: string;
                suffixTextColor: string;
                paddingTiny: string;
                paddingSmall: string;
                paddingMedium: string;
                paddingLarge: string;
                clearSize: string;
            }, any>;
            Empty: import("../../_mixins").Theme<"Empty", {
                fontSizeTiny: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                fontSizeHuge: string;
                textColor: string;
                iconColor: string;
                extraTextColor: string;
                iconSizeTiny: string;
                iconSizeSmall: string;
                iconSizeMedium: string;
                iconSizeLarge: string;
                iconSizeHuge: string;
            }, any>;
            Button: import("../../_mixins").Theme<"Button", {
                heightTiny: string;
                heightSmall: string;
                heightMedium: string;
                heightLarge: string;
                borderRadiusTiny: string;
                borderRadiusSmall: string;
                borderRadiusMedium: string;
                borderRadiusLarge: string;
                fontSizeTiny: string;
                fontSizeSmall: string;
                fontSizeMedium: string;
                fontSizeLarge: string;
                opacityDisabled: string;
                colorOpacitySecondary: string;
                colorOpacitySecondaryHover: string;
                colorOpacitySecondaryPressed: string;
                colorSecondary: string;
                colorSecondaryHover: string;
                colorSecondaryPressed: string;
                colorTertiary: string;
                colorTertiaryHover: string;
                colorTertiaryPressed: string;
                colorQuaternary: string;
                colorQuaternaryHover: string;
                colorQuaternaryPressed: string;
                color: string;
                colorHover: string;
                colorPressed: string;
                colorFocus: string;
                colorDisabled: string;
                textColor: string;
                textColorTertiary: string;
                textColorHover: string;
                textColorPressed: string;
                textColorFocus: string;
                textColorDisabled: string;
                textColorText: string;
                textColorTextHover: string;
                textColorTextPressed: string;
                textColorTextFocus: string;
                textColorTextDisabled: string;
                textColorGhost: string;
                textColorGhostHover: string;
                textColorGhostPressed: string;
                textColorGhostFocus: string;
                textColorGhostDisabled: string;
                border: string;
                borderHover: string;
                borderPressed: string;
                borderFocus: string;
                borderDisabled: string;
                rippleColor: string;
                colorPrimary: string;
                colorHoverPrimary: string;
                colorPressedPrimary: string;
                colorFocusPrimary: string;
                colorDisabledPrimary: string;
                textColorPrimary: string;
                textColorHoverPrimary: string;
                textColorPressedPrimary: string;
                textColorFocusPrimary: string;
                textColorDisabledPrimary: string;
                textColorTextPrimary: string;
                textColorTextHoverPrimary: string;
                textColorTextPressedPrimary: string;
                textColorTextFocusPrimary: string;
                textColorTextDisabledPrimary: string;
                textColorGhostPrimary: string;
                textColorGhostHoverPrimary: string;
                textColorGhostPressedPrimary: string;
                textColorGhostFocusPrimary: string;
                textColorGhostDisabledPrimary: string;
                borderPrimary: string;
                borderHoverPrimary: string;
                borderPressedPrimary: string;
                borderFocusPrimary: string;
                borderDisabledPrimary: string;
                rippleColorPrimary: string;
                colorInfo: string;
                colorHoverInfo: string;
                colorPressedInfo: string;
                colorFocusInfo: string;
                colorDisabledInfo: string;
                textColorInfo: string;
                textColorHoverInfo: string;
                textColorPressedInfo: string;
                textColorFocusInfo: string;
                textColorDisabledInfo: string;
                textColorTextInfo: string;
                textColorTextHoverInfo: string;
                textColorTextPressedInfo: string;
                textColorTextFocusInfo: string;
                textColorTextDisabledInfo: string;
                textColorGhostInfo: string;
                textColorGhostHoverInfo: string;
                textColorGhostPressedInfo: string;
                textColorGhostFocusInfo: string;
                textColorGhostDisabledInfo: string;
                borderInfo: string;
                borderHoverInfo: string;
                borderPressedInfo: string;
                borderFocusInfo: string;
                borderDisabledInfo: string;
                rippleColorInfo: string;
                colorSuccess: string;
                colorHoverSuccess: string;
                colorPressedSuccess: string;
                colorFocusSuccess: string;
                colorDisabledSuccess: string;
                textColorSuccess: string;
                textColorHoverSuccess: string;
                textColorPressedSuccess: string;
                textColorFocusSuccess: string;
                textColorDisabledSuccess: string;
                textColorTextSuccess: string;
                textColorTextHoverSuccess: string;
                textColorTextPressedSuccess: string;
                textColorTextFocusSuccess: string;
                textColorTextDisabledSuccess: string;
                textColorGhostSuccess: string;
                textColorGhostHoverSuccess: string;
                textColorGhostPressedSuccess: string;
                textColorGhostFocusSuccess: string;
                textColorGhostDisabledSuccess: string;
                borderSuccess: string;
                borderHoverSuccess: string;
                borderPressedSuccess: string;
                borderFocusSuccess: string;
                borderDisabledSuccess: string;
                rippleColorSuccess: string;
                colorWarning: string;
                colorHoverWarning: string;
                colorPressedWarning: string;
                colorFocusWarning: string;
                colorDisabledWarning: string;
                textColorWarning: string;
                textColorHoverWarning: string;
                textColorPressedWarning: string;
                textColorFocusWarning: string;
                textColorDisabledWarning: string;
                textColorTextWarning: string;
                textColorTextHoverWarning: string;
                textColorTextPressedWarning: string;
                textColorTextFocusWarning: string;
                textColorTextDisabledWarning: string;
                textColorGhostWarning: string;
                textColorGhostHoverWarning: string;
                textColorGhostPressedWarning: string;
                textColorGhostFocusWarning: string;
                textColorGhostDisabledWarning: string;
                borderWarning: string;
                borderHoverWarning: string;
                borderPressedWarning: string;
                borderFocusWarning: string;
                borderDisabledWarning: string;
                rippleColorWarning: string;
                colorError: string;
                colorHoverError: string;
                colorPressedError: string;
                colorFocusError: string;
                colorDisabledError: string;
                textColorError: string;
                textColorHoverError: string;
                textColorPressedError: string;
                textColorFocusError: string;
                textColorDisabledError: string;
                textColorTextError: string;
                textColorTextHoverError: string;
                textColorTextPressedError: string;
                textColorTextFocusError: string;
                textColorTextDisabledError: string;
                textColorGhostError: string;
                textColorGhostHoverError: string;
                textColorGhostPressedError: string;
                textColorGhostFocusError: string;
                textColorGhostDisabledError: string;
                borderError: string;
                borderHoverError: string;
                borderPressedError: string;
                borderFocusError: string;
                borderDisabledError: string;
                rippleColorError: string;
                waveOpacity: string;
                fontWeight: string;
                fontWeightStrong: string;
                paddingTiny: string;
                paddingSmall: string;
                paddingMedium: string;
                paddingLarge: string;
                paddingRoundTiny: string;
                paddingRoundSmall: string;
                paddingRoundMedium: string;
                paddingRoundLarge: string;
                iconMarginTiny: string;
                iconMarginSmall: string;
                iconMarginMedium: string;
                iconMarginLarge: string;
                iconSizeTiny: string;
                iconSizeSmall: string;
                iconSizeMedium: string;
                iconSizeLarge: string;
                rippleDuration: string;
            }, any>;
        };
        peerOverrides: {
            Checkbox?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            Scrollbar?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            Input?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            Empty?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
            Button?: {
                peers?: {
                    [x: string]: any;
                } | undefined;
            } | undefined;
        };
    }>;
    filteredSrcOpts: import("vue").ComputedRef<Option[]>;
    filteredTgtOpts: import("vue").ComputedRef<Option[]>;
    srcPattern: import("vue").Ref<string>;
    tgtPattern: import("vue").Ref<string>;
    mergedSize: import("vue").ComputedRef<"small" | "medium" | "large">;
    mergedSrcFilterable: import("vue").ComputedRef<boolean>;
    handleSrcFilterUpdateValue: (value: string | null) => void;
    handleTgtFilterUpdateValue: (value: string | null) => void;
    handleSourceCheckAll: () => void;
    handleSourceUncheckAll: () => void;
    handleTargetClearAll: () => void;
    handleItemCheck: (checked: boolean, optionValue: OptionValue) => void;
    handleChecked: (optionValueList: OptionValue[]) => void;
    cssVars: import("vue").ComputedRef<{
        '--n-bezier': string;
        '--n-border-color': string;
        '--n-border-radius': string;
        '--n-extra-font-size': string;
        '--n-font-size': string;
        '--n-header-font-size': string;
        '--n-header-extra-text-color': string;
        '--n-header-extra-text-color-disabled': string;
        '--n-header-font-weight': string;
        '--n-header-text-color': string;
        '--n-header-text-color-disabled': string;
        '--n-item-color-pending': string;
        '--n-item-height': string;
        '--n-item-text-color': string;
        '--n-item-text-color-disabled': string;
        '--n-list-color': string;
        '--n-header-height': string;
        '--n-close-size': string;
        '--n-close-icon-size': string;
        '--n-close-color-hover': string;
        '--n-close-color-pressed': string;
        '--n-close-icon-color': string;
        '--n-close-icon-color-hover': string;
        '--n-close-icon-color-pressed': string;
        '--n-divider-color': string;
    }>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<import("vue").ExtractPropTypes<{
    readonly value: PropType<OptionValue[] | null>;
    readonly defaultValue: {
        readonly type: PropType<OptionValue[] | null>;
        readonly default: null;
    };
    readonly options: {
        readonly type: PropType<Option[]>;
        readonly default: () => never[];
    };
    readonly disabled: {
        readonly type: PropType<boolean | undefined>;
        readonly default: undefined;
    };
    readonly virtualScroll: BooleanConstructor;
    readonly sourceTitle: PropType<string | (() => VNodeChild)>;
    readonly selectAllText: StringConstructor;
    readonly clearText: StringConstructor;
    readonly targetTitle: PropType<string | (() => VNodeChild)>;
    readonly filterable: {
        readonly type: BooleanConstructor;
        readonly default: undefined;
    };
    readonly sourceFilterable: BooleanConstructor;
    readonly targetFilterable: BooleanConstructor;
    readonly showSelected: {
        readonly type: BooleanConstructor;
        readonly default: true;
    };
    readonly sourceFilterPlaceholder: StringConstructor;
    readonly targetFilterPlaceholder: StringConstructor;
    readonly filter: {
        readonly type: PropType<Filter>;
        readonly default: (pattern: string, option: Option) => number | true;
    };
    readonly size: PropType<"small" | "medium" | "large">;
    readonly renderSourceLabel: PropType<TransferRenderSourceLabel>;
    readonly renderTargetLabel: PropType<TransferRenderTargetLabel>;
    readonly renderSourceList: PropType<TransferRenderSourceList>;
    readonly renderTargetList: PropType<TransferRenderSourceList>;
    readonly 'onUpdate:value': PropType<MaybeArray<OnUpdateValue>>;
    readonly onUpdateValue: PropType<MaybeArray<OnUpdateValue>>;
    readonly onChange: PropType<MaybeArray<OnUpdateValue>>;
    readonly theme: PropType<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>;
    readonly themeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
    readonly builtinThemeOverrides: PropType<import("../../_mixins/use-theme").ExtractThemeOverrides<import("../../_mixins").Theme<"Transfer", {
        itemHeightSmall: string;
        itemHeightMedium: string;
        itemHeightLarge: string;
        fontSizeSmall: string;
        fontSizeMedium: string;
        fontSizeLarge: string;
        borderRadius: string;
        dividerColor: string;
        borderColor: string;
        listColor: string;
        headerColor: string;
        titleTextColor: string;
        titleTextColorDisabled: string;
        extraTextColor: string;
        extraTextColorDisabled: string;
        itemTextColor: string;
        itemTextColorDisabled: string;
        itemColorPending: string;
        titleFontWeight: string;
        closeColorHover: string;
        closeColorPressed: string;
        closeIconColor: string;
        closeIconColorHover: string;
        closeIconColorPressed: string;
        extraFontSizeSmall: string;
        extraFontSizeMedium: string;
        extraFontSizeLarge: string;
        titleFontSizeSmall: string;
        titleFontSizeMedium: string;
        titleFontSizeLarge: string;
        closeSize: string;
        closeIconSize: string;
        headerHeightSmall: string;
        headerHeightMedium: string;
        headerHeightLarge: string;
    }, {
        Checkbox: import("../../_mixins").Theme<"Checkbox", {
            labelLineHeight: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            borderRadius: string;
            color: string;
            colorChecked: string;
            colorDisabled: string;
            colorDisabledChecked: string;
            colorTableHeader: string;
            colorTableHeaderModal: string;
            colorTableHeaderPopover: string;
            checkMarkColor: string;
            checkMarkColorDisabled: string;
            checkMarkColorDisabledChecked: string;
            border: string;
            borderDisabled: string;
            borderDisabledChecked: string;
            borderChecked: string;
            borderFocus: string;
            boxShadowFocus: string;
            textColor: string;
            textColorDisabled: string;
            sizeSmall: string;
            sizeMedium: string;
            sizeLarge: string;
            labelPadding: string;
            labelFontWeight: string;
        }, any>;
        Scrollbar: import("../../_mixins").Theme<"Scrollbar", {
            height: string;
            width: string;
            borderRadius: string;
            color: string;
            colorHover: string;
            railInsetHorizontalBottom: string;
            railInsetHorizontalTop: string;
            railInsetVerticalRight: string;
            railInsetVerticalLeft: string;
            railColor: string;
        }, any>;
        Input: import("../../_mixins").Theme<"Input", {
            countTextColorDisabled: string;
            countTextColor: string;
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            lineHeight: string;
            lineHeightTextarea: string;
            borderRadius: string;
            iconSize: string;
            groupLabelColor: string;
            groupLabelTextColor: string;
            textColor: string;
            textColorDisabled: string;
            textDecorationColor: string;
            caretColor: string;
            placeholderColor: string;
            placeholderColorDisabled: string;
            color: string;
            colorDisabled: string;
            colorFocus: string;
            groupLabelBorder: string;
            border: string;
            borderHover: string;
            borderDisabled: string;
            borderFocus: string;
            boxShadowFocus: string;
            loadingColor: string;
            loadingColorWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            colorFocusWarning: string;
            borderFocusWarning: string;
            boxShadowFocusWarning: string;
            caretColorWarning: string;
            loadingColorError: string;
            borderError: string;
            borderHoverError: string;
            colorFocusError: string;
            borderFocusError: string;
            boxShadowFocusError: string;
            caretColorError: string;
            clearColor: string;
            clearColorHover: string;
            clearColorPressed: string;
            iconColor: string;
            iconColorDisabled: string;
            iconColorHover: string;
            iconColorPressed: string;
            suffixTextColor: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            clearSize: string;
        }, any>;
        Empty: import("../../_mixins").Theme<"Empty", {
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            fontSizeHuge: string;
            textColor: string;
            iconColor: string;
            extraTextColor: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            iconSizeHuge: string;
        }, any>;
        Button: import("../../_mixins").Theme<"Button", {
            heightTiny: string;
            heightSmall: string;
            heightMedium: string;
            heightLarge: string;
            borderRadiusTiny: string;
            borderRadiusSmall: string;
            borderRadiusMedium: string;
            borderRadiusLarge: string;
            fontSizeTiny: string;
            fontSizeSmall: string;
            fontSizeMedium: string;
            fontSizeLarge: string;
            opacityDisabled: string;
            colorOpacitySecondary: string;
            colorOpacitySecondaryHover: string;
            colorOpacitySecondaryPressed: string;
            colorSecondary: string;
            colorSecondaryHover: string;
            colorSecondaryPressed: string;
            colorTertiary: string;
            colorTertiaryHover: string;
            colorTertiaryPressed: string;
            colorQuaternary: string;
            colorQuaternaryHover: string;
            colorQuaternaryPressed: string;
            color: string;
            colorHover: string;
            colorPressed: string;
            colorFocus: string;
            colorDisabled: string;
            textColor: string;
            textColorTertiary: string;
            textColorHover: string;
            textColorPressed: string;
            textColorFocus: string;
            textColorDisabled: string;
            textColorText: string;
            textColorTextHover: string;
            textColorTextPressed: string;
            textColorTextFocus: string;
            textColorTextDisabled: string;
            textColorGhost: string;
            textColorGhostHover: string;
            textColorGhostPressed: string;
            textColorGhostFocus: string;
            textColorGhostDisabled: string;
            border: string;
            borderHover: string;
            borderPressed: string;
            borderFocus: string;
            borderDisabled: string;
            rippleColor: string;
            colorPrimary: string;
            colorHoverPrimary: string;
            colorPressedPrimary: string;
            colorFocusPrimary: string;
            colorDisabledPrimary: string;
            textColorPrimary: string;
            textColorHoverPrimary: string;
            textColorPressedPrimary: string;
            textColorFocusPrimary: string;
            textColorDisabledPrimary: string;
            textColorTextPrimary: string;
            textColorTextHoverPrimary: string;
            textColorTextPressedPrimary: string;
            textColorTextFocusPrimary: string;
            textColorTextDisabledPrimary: string;
            textColorGhostPrimary: string;
            textColorGhostHoverPrimary: string;
            textColorGhostPressedPrimary: string;
            textColorGhostFocusPrimary: string;
            textColorGhostDisabledPrimary: string;
            borderPrimary: string;
            borderHoverPrimary: string;
            borderPressedPrimary: string;
            borderFocusPrimary: string;
            borderDisabledPrimary: string;
            rippleColorPrimary: string;
            colorInfo: string;
            colorHoverInfo: string;
            colorPressedInfo: string;
            colorFocusInfo: string;
            colorDisabledInfo: string;
            textColorInfo: string;
            textColorHoverInfo: string;
            textColorPressedInfo: string;
            textColorFocusInfo: string;
            textColorDisabledInfo: string;
            textColorTextInfo: string;
            textColorTextHoverInfo: string;
            textColorTextPressedInfo: string;
            textColorTextFocusInfo: string;
            textColorTextDisabledInfo: string;
            textColorGhostInfo: string;
            textColorGhostHoverInfo: string;
            textColorGhostPressedInfo: string;
            textColorGhostFocusInfo: string;
            textColorGhostDisabledInfo: string;
            borderInfo: string;
            borderHoverInfo: string;
            borderPressedInfo: string;
            borderFocusInfo: string;
            borderDisabledInfo: string;
            rippleColorInfo: string;
            colorSuccess: string;
            colorHoverSuccess: string;
            colorPressedSuccess: string;
            colorFocusSuccess: string;
            colorDisabledSuccess: string;
            textColorSuccess: string;
            textColorHoverSuccess: string;
            textColorPressedSuccess: string;
            textColorFocusSuccess: string;
            textColorDisabledSuccess: string;
            textColorTextSuccess: string;
            textColorTextHoverSuccess: string;
            textColorTextPressedSuccess: string;
            textColorTextFocusSuccess: string;
            textColorTextDisabledSuccess: string;
            textColorGhostSuccess: string;
            textColorGhostHoverSuccess: string;
            textColorGhostPressedSuccess: string;
            textColorGhostFocusSuccess: string;
            textColorGhostDisabledSuccess: string;
            borderSuccess: string;
            borderHoverSuccess: string;
            borderPressedSuccess: string;
            borderFocusSuccess: string;
            borderDisabledSuccess: string;
            rippleColorSuccess: string;
            colorWarning: string;
            colorHoverWarning: string;
            colorPressedWarning: string;
            colorFocusWarning: string;
            colorDisabledWarning: string;
            textColorWarning: string;
            textColorHoverWarning: string;
            textColorPressedWarning: string;
            textColorFocusWarning: string;
            textColorDisabledWarning: string;
            textColorTextWarning: string;
            textColorTextHoverWarning: string;
            textColorTextPressedWarning: string;
            textColorTextFocusWarning: string;
            textColorTextDisabledWarning: string;
            textColorGhostWarning: string;
            textColorGhostHoverWarning: string;
            textColorGhostPressedWarning: string;
            textColorGhostFocusWarning: string;
            textColorGhostDisabledWarning: string;
            borderWarning: string;
            borderHoverWarning: string;
            borderPressedWarning: string;
            borderFocusWarning: string;
            borderDisabledWarning: string;
            rippleColorWarning: string;
            colorError: string;
            colorHoverError: string;
            colorPressedError: string;
            colorFocusError: string;
            colorDisabledError: string;
            textColorError: string;
            textColorHoverError: string;
            textColorPressedError: string;
            textColorFocusError: string;
            textColorDisabledError: string;
            textColorTextError: string;
            textColorTextHoverError: string;
            textColorTextPressedError: string;
            textColorTextFocusError: string;
            textColorTextDisabledError: string;
            textColorGhostError: string;
            textColorGhostHoverError: string;
            textColorGhostPressedError: string;
            textColorGhostFocusError: string;
            textColorGhostDisabledError: string;
            borderError: string;
            borderHoverError: string;
            borderPressedError: string;
            borderFocusError: string;
            borderDisabledError: string;
            rippleColorError: string;
            waveOpacity: string;
            fontWeight: string;
            fontWeightStrong: string;
            paddingTiny: string;
            paddingSmall: string;
            paddingMedium: string;
            paddingLarge: string;
            paddingRoundTiny: string;
            paddingRoundSmall: string;
            paddingRoundMedium: string;
            paddingRoundLarge: string;
            iconMarginTiny: string;
            iconMarginSmall: string;
            iconMarginMedium: string;
            iconMarginLarge: string;
            iconSizeTiny: string;
            iconSizeSmall: string;
            iconSizeMedium: string;
            iconSizeLarge: string;
            rippleDuration: string;
        }, any>;
    }>>>;
}>>, {
    readonly options: Option[];
    readonly filter: Filter;
    readonly disabled: boolean | undefined;
    readonly filterable: boolean;
    readonly virtualScroll: boolean;
    readonly defaultValue: OptionValue[] | null;
    readonly showSelected: boolean;
    readonly sourceFilterable: boolean;
    readonly targetFilterable: boolean;
}, {}>;
export default _default;
