/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.ws;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.swagger.invocation.ws.ClientWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.ServerWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketPipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketPipe.class);
    private final String websocketSessionId;
    private final PipeServerWebSocket serverWebSocket;
    private final PipeClientWebSocket clientWebSocket;
    private final Object statusLock = new Object();

    public WebSocketPipe(String websocketSessionId) {
        this.websocketSessionId = websocketSessionId;
        this.clientWebSocket = new PipeClientWebSocket();
        this.serverWebSocket = new PipeServerWebSocket();
        this.clientWebSocket.connect(this.serverWebSocket);
        this.serverWebSocket.connect(this.clientWebSocket);
    }

    public ClientWebSocket getClientWebSocket() {
        return this.clientWebSocket;
    }

    public ServerWebSocket getServerWebSocket() {
        return this.serverWebSocket;
    }

    private class PipeClientWebSocket
    extends ClientWebSocket {
        PipeServerWebSocket peer;
        private PipeWebSocketStatus status = PipeWebSocketStatus.CREATED;

        private PipeClientWebSocket() {
        }

        void connect(PipeServerWebSocket peer) {
            this.transferStatus(PipeWebSocketStatus.CREATED, PipeWebSocketStatus.PEER_CONNECTED);
            this.peer = peer;
        }

        @Override
        public void onConnectionReady() {
            this.pause();
            this.onOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOpen() {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.transferStatus(PipeWebSocketStatus.PEER_CONNECTED, PipeWebSocketStatus.OPENED);
                if (this.peer.status == PipeWebSocketStatus.OPENED) {
                    this.resume();
                    this.transferStatus(PipeWebSocketStatus.OPENED, PipeWebSocketStatus.RUNNING);
                    this.peer.resume();
                    this.peer.transferStatus(PipeWebSocketStatus.OPENED, PipeWebSocketStatus.RUNNING);
                }
            }
        }

        @Override
        public void onMessage(WebSocketMessage<?> message) {
            this.peer.sendMessage(message).whenComplete((v, t) -> {
                if (t != null) {
                    LOGGER.error("[{}] failed to forward message", (Object)WebSocketPipe.this.websocketSessionId, t);
                }
            });
            if (this.peer.writeQueueFull()) {
                this.pause();
                LOGGER.debug("[{}] pipe paused, direction is client to server", (Object)WebSocketPipe.this.websocketSessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            LOGGER.error("[{}] websocket error", (Object)WebSocketPipe.this.websocketSessionId, (Object)t);
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.transferStatus(PipeWebSocketStatus.ERROR);
                this.safelyClose((short)WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText());
            }
        }

        @Override
        public void onClose(Short closeStatusCode, String closeReason) {
            this.transferStatus(PipeWebSocketStatus.CLOSED);
            this.safelyClose(closeStatusCode, closeReason);
        }

        @Override
        public void onWriteQueueDrain() {
            this.peer.resume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferStatus(PipeWebSocketStatus newStatus) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.status = newStatus;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferStatus(PipeWebSocketStatus expectedOldStatus, PipeWebSocketStatus newStatus) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                if (this.status != expectedOldStatus) {
                    this.safelyClose((short)WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText());
                    LOGGER.error("[{}] illegal state transfer: from {} to {}", new Object[]{WebSocketPipe.this.websocketSessionId, expectedOldStatus, newStatus});
                    throw new IllegalStateException("Illegal state transfer: [" + (Object)((Object)expectedOldStatus) + "] to [" + (Object)((Object)newStatus) + "]");
                }
                this.status = newStatus;
            }
        }

        private void safelyClose(Short closeStatusCode, String closeReason) {
            try {
                this.close(closeStatusCode, closeReason);
            }
            catch (Throwable e) {
                LOGGER.error("[{}] failed to close pipe client websocket", (Object)WebSocketPipe.this.websocketSessionId, (Object)e);
            }
            if (this.peer == null) {
                return;
            }
            try {
                this.peer.close(closeStatusCode, closeReason);
            }
            catch (Throwable e) {
                LOGGER.error("[{}] failed to close pipe server websocket", (Object)WebSocketPipe.this.websocketSessionId, (Object)e);
            }
        }
    }

    private class PipeServerWebSocket
    extends ServerWebSocket {
        PipeClientWebSocket peer;
        private PipeWebSocketStatus status = PipeWebSocketStatus.CREATED;

        private PipeServerWebSocket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect(PipeClientWebSocket peer) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.transferStatus(PipeWebSocketStatus.CREATED, PipeWebSocketStatus.PEER_CONNECTED);
                this.peer = peer;
            }
        }

        @Override
        public void onConnectionReady() {
            this.pause();
            this.onOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOpen() {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.transferStatus(PipeWebSocketStatus.PEER_CONNECTED, PipeWebSocketStatus.OPENED);
                if (this.peer.status == PipeWebSocketStatus.OPENED) {
                    this.resume();
                    this.transferStatus(PipeWebSocketStatus.OPENED, PipeWebSocketStatus.RUNNING);
                    this.peer.resume();
                    this.peer.transferStatus(PipeWebSocketStatus.OPENED, PipeWebSocketStatus.RUNNING);
                }
            }
        }

        @Override
        public void onMessage(WebSocketMessage<?> message) {
            this.peer.sendMessage(message).whenComplete((v, t) -> {
                if (t != null) {
                    LOGGER.error("[{}] failed to forward message", (Object)WebSocketPipe.this.websocketSessionId, t);
                }
            });
            if (this.peer.writeQueueFull()) {
                this.pause();
                LOGGER.debug("[{}] pipe paused, direction is server to client", (Object)WebSocketPipe.this.websocketSessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            LOGGER.error("[{}] websocket error", (Object)WebSocketPipe.this.websocketSessionId, (Object)t);
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.transferStatus(PipeWebSocketStatus.ERROR);
                this.safelyClose((short)WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText());
            }
        }

        @Override
        public void onClose(Short closeStatusCode, String closeReason) {
            this.transferStatus(PipeWebSocketStatus.CLOSED);
            this.safelyClose(closeStatusCode, closeReason);
        }

        @Override
        public void onWriteQueueDrain() {
            this.peer.resume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Void> close(Short closeStatusCode, String closeReason) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                if (this.status == PipeWebSocketStatus.CLOSING || this.status == PipeWebSocketStatus.CLOSED) {
                    return CompletableFuture.completedFuture(null);
                }
                this.transferStatus(PipeWebSocketStatus.CLOSING);
                if (this.status.ordinal() < PipeWebSocketStatus.RUNNING.ordinal()) {
                    this.transferStatus(PipeWebSocketStatus.CLOSED);
                    return CompletableFuture.completedFuture(null);
                }
                return super.close(closeStatusCode, closeReason).whenComplete((result, throwable) -> this.transferStatus(PipeWebSocketStatus.CLOSED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferStatus(PipeWebSocketStatus newStatus) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                this.status = newStatus;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferStatus(PipeWebSocketStatus expectedOldStatus, PipeWebSocketStatus newStatus) {
            Object object = WebSocketPipe.this.statusLock;
            synchronized (object) {
                if (this.status != expectedOldStatus) {
                    this.safelyClose((short)WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText());
                    LOGGER.error("[{}] illegal state transfer: from {} to {}", new Object[]{WebSocketPipe.this.websocketSessionId, expectedOldStatus, newStatus});
                    throw new IllegalStateException("Illegal state transfer: [" + (Object)((Object)expectedOldStatus) + "] to [" + (Object)((Object)newStatus) + "]");
                }
                this.status = newStatus;
            }
        }

        private void safelyClose(Short closeStatusCode, String closeReason) {
            try {
                this.close(closeStatusCode, closeReason);
            }
            catch (Throwable e) {
                LOGGER.error("[{}] failed to close pipe server websocket", (Object)WebSocketPipe.this.websocketSessionId, (Object)e);
            }
            if (this.peer == null) {
                return;
            }
            try {
                this.peer.close(closeStatusCode, closeReason);
            }
            catch (Throwable e) {
                LOGGER.error("[{}] failed to close pipe client websocket", (Object)WebSocketPipe.this.websocketSessionId, (Object)e);
            }
        }
    }

    private static enum PipeWebSocketStatus {
        CREATED,
        PEER_CONNECTED,
        OPENED,
        RUNNING,
        ERROR,
        CLOSING,
        CLOSED;

    }
}

