/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.advice;

import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.core.advice.AbstractInstanceMethodAdvice;
import org.apache.shardingsphere.agent.plugin.core.util.SQLStatementUtils;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.CounterMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class SQLRouteCountAdvice
extends AbstractInstanceMethodAdvice {
    private final MetricConfiguration config = new MetricConfiguration("routed_sql_total", MetricCollectorType.COUNTER, "Total count of routed SQL", Collections.singletonList("type"), Collections.emptyMap());

    public void beforeMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, String pluginType) {
        QueryContext queryContext = (QueryContext)args[0];
        SQLStatement sqlStatement = queryContext.getSqlStatementContext().getSqlStatement();
        this.getSQLType(sqlStatement).ifPresent(optional -> ((CounterMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType)).inc((String)optional));
    }

    private Optional<String> getSQLType(SQLStatement sqlStatement) {
        return Optional.of(SQLStatementUtils.getType((SQLStatement)sqlStatement).name());
    }
}

