/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.jdbc;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.agent.plugin.core.context.ShardingSphereDataSourceContext;
import org.apache.shardingsphere.agent.plugin.core.holder.ShardingSphereDataSourceContextHolder;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.GaugeMetricFamilyMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.MetricsExporter;

public final class JDBCStateExporter
implements MetricsExporter {
    private final MetricConfiguration config = new MetricConfiguration("jdbc_state", MetricCollectorType.GAUGE_METRIC_FAMILY, "State of ShardingSphere-JDBC. 0 is OK; 1 is CIRCUIT BREAK", Arrays.asList("driver_instance", "database"));

    @Override
    public Optional<GaugeMetricFamilyMetricsCollector> export(String pluginType) {
        GaugeMetricFamilyMetricsCollector result = (GaugeMetricFamilyMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType);
        result.cleanMetrics();
        for (Map.Entry entry : ShardingSphereDataSourceContextHolder.getShardingSphereDataSourceContexts().entrySet()) {
            Optional.ofNullable(((ShardingSphereDataSourceContext)entry.getValue()).getContextManager().getDatabase(((ShardingSphereDataSourceContext)entry.getValue()).getDatabaseName())).ifPresent(optional -> result.addMetric(Arrays.asList((String)entry.getKey(), optional.getName()), ((ShardingSphereDataSourceContext)entry.getValue()).getContextManager().getComputeNodeInstanceContext().getInstance().getState().getCurrentState().ordinal()));
        }
        return Optional.of(result);
    }
}

