/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.AgentAdvice;
import org.apache.shardingsphere.agent.core.plugin.classloader.ClassLoaderContext;

public final class AdviceFactory {
    private static final Map<String, AgentAdvice> CACHED_ADVICES = new ConcurrentHashMap<String, AgentAdvice>();
    private final ClassLoaderContext classLoaderContext;

    public AgentAdvice getAdvice(String adviceClassName) {
        ClassLoader appClassLoader = this.classLoaderContext.getAppClassLoader();
        String cacheKey = String.format("%s_%s@%s", adviceClassName, appClassLoader.getClass().getName(), Integer.toHexString(appClassLoader.hashCode()));
        return CACHED_ADVICES.computeIfAbsent(cacheKey, key -> this.createAdvice(adviceClassName));
    }

    private AgentAdvice createAdvice(String adviceClassName) {
        return (AgentAdvice)Class.forName(adviceClassName, true, this.classLoaderContext.getPluginClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Generated
    public AdviceFactory(ClassLoaderContext classLoaderContext) {
        this.classLoaderContext = classLoaderContext;
    }
}

