/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.tracing.opentelemetry.advice;

import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.tracing.core.advice.TracingRootSpanAdvice;
import org.apache.shardingsphere.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.StatusCode;

public final class OpenTelemetryRootSpanAdvice
extends TracingRootSpanAdvice<Span> {
    @Override
    protected Span createRootSpan(TargetAdviceObject target, TargetAdviceMethod method, Object[] args2) {
        SpanBuilder spanBuilder = GlobalOpenTelemetry.getTracer("shardingsphere-agent").spanBuilder("/ShardingSphere/rootInvoke/").setAttribute("component", "ShardingSphere").setAttribute("span.kind", "client");
        return spanBuilder.startSpan();
    }

    @Override
    protected void finishRootSpan(Span rootSpan, TargetAdviceObject target) {
        rootSpan.setStatus(StatusCode.OK);
        rootSpan.end();
    }

    @Override
    protected void recordException(Span rootSpan, TargetAdviceObject target, Throwable throwable) {
        rootSpan.setStatus(StatusCode.ERROR).recordException(throwable);
        rootSpan.end();
    }
}

