/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.http.HttpExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final Deque<LowAllocationTraceRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationTraceRequestMarshaler>();
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    private final MemoryMode memoryMode;

    OtlpHttpSpanExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.memoryMode = memoryMode;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationTraceRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationTraceRequestMarshaler();
            }
            LowAllocationTraceRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(spans);
            return this.delegate.export(exportMarshaler, spans.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.delegate.export(request, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

