/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal;

import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterComponentProvider
implements ComponentProvider<MetricExporter> {
    @Override
    public Class<MetricExporter> getType() {
        return MetricExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public MetricExporter create(StructuredConfigProperties config) {
        String protocol = OtlpConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

