/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal;

import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    @Override
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public SpanExporter create(StructuredConfigProperties config) {
        String protocol = OtlpConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

