/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.utils.StringUtils;
import java.util.Map;
import java.util.Objects;

public class RouteArgument {
    public static final String LABEL_KEY_METHOD = "$method";
    public static final String LABEL_KEY_HEADER = "$header.";
    public static final String LABEL_KEY_QUERY = "$query.";
    public static final String LABEL_KEY_COOKIE = "$cookie.";
    public static final String LABEL_KEY_PATH = "$path";
    public static final String LABEL_KEY_CALLER_IP = "$caller_ip";
    private final ArgumentType type;
    private final String key;
    private final String value;

    private RouteArgument(ArgumentType type, String key, String value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static RouteArgument buildCustom(String key, String value) {
        return new RouteArgument(ArgumentType.CUSTOM, StringUtils.defaultString(key), StringUtils.defaultString(value));
    }

    public static RouteArgument buildMethod(String method) {
        return new RouteArgument(ArgumentType.METHOD, "", StringUtils.defaultString(method));
    }

    public static RouteArgument buildHeader(String headerKey, String headerValue) {
        return new RouteArgument(ArgumentType.HEADER, StringUtils.defaultString(headerKey), StringUtils.defaultString(headerValue));
    }

    public static RouteArgument buildQuery(String queryKey, String queryValue) {
        return new RouteArgument(ArgumentType.QUERY, StringUtils.defaultString(queryKey), StringUtils.defaultString(queryValue));
    }

    public static RouteArgument buildCookie(String cookieKey, String cookieValue) {
        return new RouteArgument(ArgumentType.COOKIE, StringUtils.defaultString(cookieKey), StringUtils.defaultString(cookieValue));
    }

    public static RouteArgument buildPath(String path) {
        return new RouteArgument(ArgumentType.PATH, "", StringUtils.defaultString(path));
    }

    public static RouteArgument buildCallerIP(String callerIP) {
        return new RouteArgument(ArgumentType.CALLER_IP, "", StringUtils.defaultString(callerIP));
    }

    public static RouteArgument fromLabel(String labelKey, String labelValue) {
        if (StringUtils.equals(labelKey = StringUtils.defaultString(labelKey), LABEL_KEY_METHOD)) {
            return RouteArgument.buildMethod(labelValue);
        }
        if (StringUtils.equals(labelKey, LABEL_KEY_CALLER_IP)) {
            return RouteArgument.buildCallerIP(labelValue);
        }
        if (labelKey.startsWith(LABEL_KEY_HEADER)) {
            return RouteArgument.buildHeader(labelKey.substring(LABEL_KEY_HEADER.length()), labelValue);
        }
        if (labelKey.startsWith(LABEL_KEY_QUERY)) {
            return RouteArgument.buildQuery(labelKey.substring(LABEL_KEY_QUERY.length()), labelValue);
        }
        if (labelKey.startsWith(LABEL_KEY_COOKIE)) {
            return RouteArgument.buildCookie(labelKey.substring(LABEL_KEY_COOKIE.length()), labelValue);
        }
        if (StringUtils.equals(labelKey, LABEL_KEY_PATH)) {
            return RouteArgument.buildPath(labelValue);
        }
        return RouteArgument.buildCustom(labelKey, labelValue);
    }

    public void toLabel(Map<String, String> labels) {
        switch (this.type) {
            case METHOD: {
                labels.put(LABEL_KEY_METHOD, this.value);
                break;
            }
            case CALLER_IP: {
                labels.put(LABEL_KEY_CALLER_IP, this.value);
                break;
            }
            case HEADER: {
                labels.put(LABEL_KEY_HEADER + this.key, this.value);
                break;
            }
            case QUERY: {
                labels.put(LABEL_KEY_QUERY + this.key, this.value);
                break;
            }
            case COOKIE: {
                labels.put(LABEL_KEY_COOKIE + this.key, this.value);
                break;
            }
            case PATH: {
                labels.put(LABEL_KEY_PATH, this.value);
                break;
            }
            case CUSTOM: {
                labels.put(this.key, this.value);
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteArgument)) {
            return false;
        }
        RouteArgument that = (RouteArgument)o;
        return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value});
    }

    public String toString() {
        return "RouteArgument{type=" + (Object)((Object)this.type) + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static enum ArgumentType {
        CUSTOM,
        METHOD,
        HEADER,
        QUERY,
        COOKIE,
        PATH,
        CALLER_IP;

    }
}

