/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.util;

import com.tencent.polaris.api.utils.StringUtils;
import java.time.Duration;
import java.util.regex.Pattern;

public class DurationUtils {
    private static final Pattern PATTERN_DIGITAL = Pattern.compile("^[0-9]+$", 2);
    private static final Pattern PATTERN_SECOND = Pattern.compile("^[0-9]+s$", 2);
    private static final Pattern PATTERN_HOUR = Pattern.compile("^[0-9]+h$", 2);
    private static final Pattern PATTERN_MINUTE = Pattern.compile("^[0-9]+m$", 2);
    private static final Pattern PATTERN_MILLIS = Pattern.compile("^[0-9]+ms$", 2);

    public static long parseDurationMillis(String value) {
        if (PATTERN_DIGITAL.matcher(value).matches()) {
            return Long.parseLong(value);
        }
        if (PATTERN_SECOND.matcher(value).matches() || PATTERN_HOUR.matcher(value).matches() || PATTERN_MINUTE.matcher(value).matches()) {
            return Duration.parse(String.format("pt%s", value)).toMillis();
        }
        if (PATTERN_MILLIS.matcher(value).matches()) {
            String digitalValue = value.substring(0, value.length() - 2);
            return Long.parseLong(digitalValue);
        }
        return -1L;
    }

    public static long parseConfigDurationStr(String durationStr, String label, long originalValue, long defaultValue) throws IllegalArgumentException {
        if (originalValue > 0L) {
            return originalValue;
        }
        long timeDurationMs = defaultValue;
        if (StringUtils.isNotBlank(durationStr) && (timeDurationMs = DurationUtils.parseDurationMillis(durationStr)) <= 0L) {
            throw new IllegalArgumentException(String.format("%s has invalid value %s", label, durationStr));
        }
        return timeDurationMs;
    }
}

