/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public abstract class HalfOpenCounter {
    private final Map<StatusDimension, CounterGroup> counterGroups = new ConcurrentHashMap<StatusDimension, CounterGroup>();
    private final Function<StatusDimension, CounterGroup> create = new Function<StatusDimension, CounterGroup>(){

        @Override
        public CounterGroup apply(StatusDimension statusDimension) {
            return new CounterGroup();
        }
    };

    private CounterGroup getCounter(StatusDimension statusDimension) {
        return this.counterGroups.computeIfAbsent(statusDimension, this.create);
    }

    public abstract Set<StatusDimension> getStatusDimensions();

    public void resetHalfOpen(StatusDimension statusDimension) {
        CounterGroup counter = this.getCounter(statusDimension);
        counter.reset();
    }

    public int getHalfOpenSuccessCount(StatusDimension statusDimension) {
        CounterGroup counter = this.getCounter(statusDimension);
        return counter.getHalfOpenSuccessCount();
    }

    public int getHalfOpenFailCount(StatusDimension statusDimension) {
        CounterGroup counter = this.getCounter(statusDimension);
        return counter.getHalfOpenFailCount();
    }

    public boolean triggerHalfOpenConversion(StatusDimension statusDimension, RetStatus retStatus, HalfOpenConfig halfOpenConfig) {
        CounterGroup counter = this.getCounter(statusDimension);
        if (retStatus == RetStatus.RetFail || retStatus == RetStatus.RetTimeout) {
            int failCount = counter.failCounter.incrementAndGet();
            return failCount == halfOpenConfig.getHalfOpenFailCount();
        }
        if (retStatus == RetStatus.RetSuccess) {
            int successCount = counter.successCounter.incrementAndGet();
            return successCount == halfOpenConfig.getHalfOpenSuccessCount();
        }
        return false;
    }

    public abstract void resetCounter(StatusDimension var1);

    private static class CounterGroup {
        final AtomicInteger successCounter = new AtomicInteger(0);
        final AtomicInteger failCounter = new AtomicInteger(0);

        private CounterGroup() {
        }

        void reset() {
            this.successCounter.set(0);
            this.failCounter.set(0);
        }

        int getHalfOpenSuccessCount() {
            return this.successCounter.get();
        }

        int getHalfOpenFailCount() {
            return this.failCounter.get();
        }
    }
}

