/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.netflix.config.DefaultContextualPredicate;
import com.netflix.config.PropertyWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DynamicContextualProperty<T>
extends PropertyWrapper<T> {
    private static Predicate<Map<String, Collection<String>>> defaultPredicate = DefaultContextualPredicate.PROPERTY_BASED;
    private final Predicate<Map<String, Collection<String>>> predicate;
    @VisibleForTesting
    volatile List<Value<T>> values;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<T> classType;

    public DynamicContextualProperty(String propName, T defaultValue, Predicate<Map<String, Collection<String>>> predicate) {
        super(propName, defaultValue);
        this.classType = defaultValue.getClass();
        this.predicate = predicate;
        this.propertyChangedInternal();
    }

    public DynamicContextualProperty(String propName, T defaultValue) {
        super(propName, defaultValue);
        this.classType = defaultValue.getClass();
        this.predicate = defaultPredicate;
        this.propertyChangedInternal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void propertyChangedInternal() {
        if (this.prop.getString() != null) {
            try {
                this.values = (List)this.mapper.readValue(this.prop.getString(), new TypeReference<List<Value<T>>>(){});
                return;
            }
            catch (Throwable e) {
                Optional<T> cachedValue = this.prop.getCachedValue(this.classType);
                if (cachedValue.isPresent()) {
                    Object value = cachedValue.get();
                    this.values = Lists.newArrayList();
                    this.values.add(new Value<Object>(value));
                } else {
                    this.values = null;
                }
                if (this.values != null) return;
                throw new RuntimeException("Unable to parse the property value: " + this.prop.getString(), e);
            }
        } else {
            this.values = null;
        }
    }

    @Override
    protected final void propertyChanged() {
        this.propertyChangedInternal();
        this.propertyChanged(this.getValue());
    }

    @Override
    public T getValue() {
        if (this.values != null) {
            for (Value<T> v : this.values) {
                if (v.getDimensions() != null && !v.getDimensions().isEmpty() && !this.predicate.apply(v.getDimensions())) continue;
                return v.getValue();
            }
        }
        return (T)this.defaultValue;
    }

    public static class Value<T> {
        private Map<String, Collection<String>> dimensions;
        private T value;
        private String comment;
        private boolean runtimeEval = false;

        public Value() {
        }

        public Value(T value) {
            this.value = value;
        }

        @JsonProperty(value="if")
        public final Map<String, Collection<String>> getDimensions() {
            return this.dimensions;
        }

        @JsonProperty(value="if")
        public final void setDimensions(Map<String, Collection<String>> dimensions) {
            this.dimensions = dimensions;
        }

        public final T getValue() {
            return this.value;
        }

        public final void setValue(T value) {
            this.value = value;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final boolean isRuntimeEval() {
            return this.runtimeEval;
        }

        public final void setRuntimeEval(boolean runtimeEval) {
            this.runtimeEval = runtimeEval;
        }
    }
}

