/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraDriverHealthIndicator;
import org.springframework.boot.actuate.cassandra.CassandraDriverReactiveHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class CassandraHealthContributorConfigurations {
    CassandraHealthContributorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraReactiveDriverConfiguration
    extends CompositeReactiveHealthContributorConfiguration<CassandraDriverReactiveHealthIndicator, CqlSession> {
        CassandraReactiveDriverConfiguration() {
            super(CassandraDriverReactiveHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        ReactiveHealthContributor cassandraHealthContributor(Map<String, CqlSession> sessions) {
            return (ReactiveHealthContributor)this.createContributor(sessions);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraDriverConfiguration
    extends CompositeHealthContributorConfiguration<CassandraDriverHealthIndicator, CqlSession> {
        CassandraDriverConfiguration() {
            super(CassandraDriverHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        HealthContributor cassandraHealthContributor(Map<String, CqlSession> sessions) {
            return (HealthContributor)this.createContributor(sessions);
        }
    }
}

