/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class DynamicPeriodicTrigger
implements Trigger {
    private Duration initialDuration = Duration.ofMillis(0L);
    private Duration duration;
    private boolean fixedRate = false;

    public DynamicPeriodicTrigger(long period) {
        this(Duration.ofMillis(period));
    }

    public DynamicPeriodicTrigger(Duration duration) {
        Assert.notNull((Object)duration, (String)"duration must not be null");
        Assert.isTrue((!duration.isNegative() ? 1 : 0) != 0, (String)"duration must not be negative");
        this.duration = duration;
    }

    public void setInitialDuration(Duration initialDuration) {
        Assert.notNull((Object)initialDuration, (String)"initialDuration must not be null");
        Assert.isTrue((!initialDuration.isNegative() ? 1 : 0) != 0, (String)"initialDuration must not be negative");
        this.initialDuration = initialDuration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        Assert.notNull((Object)duration, (String)"duration must not be null");
        this.duration = duration;
    }

    public Duration getInitialDuration() {
        return this.initialDuration;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public Instant nextExecution(TriggerContext triggerContext) {
        Instant lastScheduled = triggerContext.lastScheduledExecution();
        if (lastScheduled == null) {
            return Instant.now().plus(this.initialDuration);
        }
        if (this.fixedRate) {
            return lastScheduled.plus(this.duration);
        }
        return triggerContext.lastCompletion().plus(this.duration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicPeriodicTrigger that = (DynamicPeriodicTrigger)obj;
        return this.fixedRate == that.fixedRate && Objects.equals(this.initialDuration, that.initialDuration) && Objects.equals(this.duration, that.duration);
    }

    public int hashCode() {
        return Objects.hash(this.initialDuration, this.duration, this.fixedRate);
    }
}

