/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.FunctionRegister;
import org.apache.sis.filter.sqlmm.Registry;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.referencing.internal.shared.LazySet;
import org.apache.sis.system.Reflect;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;

final class Capabilities {
    private final LazySet<FunctionRegister> providers;
    private Iterator<FunctionRegister> registerIterator;
    private String[] functionNames = CharSequences.EMPTY_ARRAY;
    private FunctionRegister[] registerForName;

    Capabilities(final Geometries<?> geometries) {
        this.providers = new LazySet<FunctionRegister>(this){
            final /* synthetic */ Capabilities this$0;
            {
                this.this$0 = this$0;
            }

            protected int characteristics() {
                return 257;
            }

            protected FunctionRegister[] initialValues() {
                return new FunctionRegister[]{new Registry(geometries)};
            }

            protected Iterator<FunctionRegister> createSourceIterator() {
                return ServiceLoader.load(FunctionRegister.class, Reflect.getContextClassLoader()).iterator();
            }
        };
    }

    private FunctionRegister nextFunctionRegister() {
        assert (Thread.holdsLock(this));
        if (this.registerIterator == null) {
            if (this.registerForName != null) {
                return null;
            }
            this.registerIterator = this.providers.iterator();
        }
        if (!this.registerIterator.hasNext()) {
            return null;
        }
        FunctionRegister register = this.registerIterator.next();
        String[] combined = (String[])ArraysExt.concatenate((Object[][])new String[][]{this.functionNames, (String[])register.getNames().toArray(String[]::new)});
        Arrays.sort(combined, String.CASE_INSENSITIVE_ORDER);
        Object[] registers = new FunctionRegister[combined.length];
        Arrays.fill(registers, register);
        if (this.registerForName != null) {
            int i = 0;
            int s = 0;
            while (s < this.functionNames.length) {
                if (combined[i].equalsIgnoreCase(this.functionNames[s])) {
                    registers[i] = this.registerForName[s++];
                }
                ++i;
            }
        }
        this.registerForName = registers;
        this.functionNames = combined;
        return register;
    }

    private int indexOfFunction(String name) {
        int i;
        while ((i = Arrays.binarySearch(this.functionNames, name, String.CASE_INSENSITIVE_ORDER)) < 0) {
            if (this.nextFunctionRegister() != null) continue;
            return -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Expression<R, ?> createFunction(String name, Expression<R, ?>[] parameters) {
        FunctionRegister[] registers;
        String[] names;
        int i;
        Capabilities capabilities = this;
        synchronized (capabilities) {
            i = this.indexOfFunction(name);
            if (i < 0) {
                return null;
            }
            int upper = i;
            while (++upper < this.functionNames.length && name.equalsIgnoreCase(this.functionNames[upper])) {
            }
            while (i != 0 && name.equalsIgnoreCase(this.functionNames[i - 1])) {
                --i;
            }
            names = Arrays.copyOfRange(this.functionNames, i, upper);
            registers = Arrays.copyOfRange(this.registerForName, i, upper);
        }
        IllegalArgumentException cause = null;
        for (i = 0; i < names.length; ++i) {
            try {
                return registers[i].create(names[i], parameters);
            }
            catch (IllegalArgumentException e) {
                if (cause == null) {
                    cause = e;
                    continue;
                }
                cause.addSuppressed(e);
                continue;
            }
        }
        if (cause != null) {
            throw cause;
        }
        return null;
    }
}

