/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.GridCacheValue;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public final class Linearizer {
    private static final int SOURCE_DIMENSION = 2;
    private final CommonCRS datum;
    final Type type;
    private SingleCRS targetCRS;
    private boolean axisSwap;
    private float longitudeSpan;

    public Linearizer(CommonCRS datum, Type type) {
        this.datum = datum;
        this.type = type;
    }

    final String name() {
        return this.type.name();
    }

    final SingleCRS getTargetCRS() {
        return this.targetCRS;
    }

    final boolean axisSwap() {
        return this.axisSwap;
    }

    final InternationalString getPotentialCause() {
        if (this.longitudeSpan >= 174.0f) {
            InternationalString name = IdentifiedObjects.getDisplayName((IdentifiedObject)this.targetCRS);
            return Resources.formatInternational((short)27, Float.valueOf(this.longitudeSpan), name != null ? name : this.type);
        }
        return null;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"type", this.type, "targetCRS", IdentifiedObjects.getName((IdentifiedObject)this.targetCRS, null)});
    }

    private MathTransform gridToTargetCRS(LocalizationGridBuilder grid, int xdim, int ydim) throws TransformException {
        double y;
        double ymax;
        double x;
        double xmax;
        switch (this.type.ordinal()) {
            default: {
                throw new AssertionError((Object)this.type);
            }
            case 0: 
        }
        Envelope bounds = grid.getSourceEnvelope(false);
        double[] median = grid.getControlPoint((int)Math.round(bounds.getMedian(0)), (int)Math.round(bounds.getMedian(1)));
        double xmin = xmax = (x = median[xdim]);
        double ymin = ymax = (y = median[ydim]);
        int[] gc = new int[2];
        for (int i = 0; i < 4; ++i) {
            for (int d = 0; d < 2; ++d) {
                gc[d] = (int)Math.round((i & 1 << d) == 0 ? bounds.getMinimum(d) : bounds.getMaximum(d));
            }
            double[] cp = grid.getControlPoint(gc[0], gc[1]);
            double c = cp[xdim];
            if (c < xmin) {
                xmin = c;
            }
            if (c > xmax) {
                xmax = c;
            }
            if ((c = cp[ydim]) < ymin) {
                ymin = c;
            }
            if (!(c > ymax)) continue;
            ymax = c;
        }
        this.longitudeSpan = (float)(xmax - xmin);
        if (ymin >= 60.0) {
            y = ymax;
        } else if (ymax <= -60.0) {
            y = ymin;
        }
        ProjectedCRS crs = this.datum.universal(y, x);
        assert (ReferencingUtilities.startsWithNorthEast((CoordinateSystem)crs.getBaseCRS().getCoordinateSystem()));
        MathTransform transform = crs.getConversionFromBase().getMathTransform();
        this.targetCRS = crs;
        boolean bl = this.axisSwap = ydim < xdim;
        if (!this.axisSwap) {
            Matrix3 m = new Matrix3();
            m.m11 = 0.0;
            m.m00 = 0.0;
            m.m10 = 1.0;
            m.m01 = 1.0;
            transform = MathTransforms.concatenate((MathTransform)MathTransforms.linear((Matrix)m), (MathTransform)transform);
        }
        return transform;
    }

    static void setCandidatesOnGrid(Axis[] sourceAxes, Set<Linearizer> linearizers, LocalizationGridBuilder grid) throws TransformException {
        int xdim = -1;
        int ydim = -1;
        int i = sourceAxes.length;
        while (--i >= 0) {
            switch (sourceAxes[i].abbreviation) {
                case '\u03bb': {
                    xdim = i;
                    break;
                }
                case '\u03c6': {
                    ydim = i;
                }
            }
        }
        if ((xdim | ydim) >= 0) {
            HashMap<String, MathTransform> projections = new HashMap<String, MathTransform>();
            for (Linearizer linearizer : linearizers) {
                MathTransform transform = linearizer.gridToTargetCRS(grid, xdim, ydim);
                projections.put(linearizer.name(), transform);
            }
            grid.addLinearizers(projections, false, new int[]{Math.min(xdim, ydim), Math.max(xdim, ydim)});
        }
    }

    static void replaceInCompoundCRS(SingleCRS[] components, List<GridCacheValue> replacements, Matrix reorderGridToCRS) throws DataStoreReferencingException {
        Matrix original = null;
        block0: for (GridCacheValue replacement : replacements) {
            SingleCRS targetCRS = replacement.linearizationTarget;
            CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
            int firstDimension = 0;
            for (int i = 0; i < components.length; ++i) {
                SingleCRS sourceCRS = components[i];
                int[] r = AxisDirections.indicesOfLenientMapping((CoordinateSystem)sourceCRS.getCoordinateSystem(), (CoordinateSystem)targetCS);
                if (r != null) {
                    components[i] = targetCRS;
                    if (replacement.axisSwap) {
                        ArraysExt.swap((int[])r, (int)0, (int)1);
                    }
                    for (int j = 0; j < r.length; ++j) {
                        if (r[j] == j) continue;
                        int oldRow = r[j] + firstDimension;
                        int newRow = j + firstDimension;
                        if (original == null) {
                            original = reorderGridToCRS.clone();
                        }
                        int k = original.getNumCol();
                        while (--k >= 0) {
                            reorderGridToCRS.setElement(newRow, k, original.getElement(oldRow, k));
                        }
                    }
                    continue block0;
                }
                firstDimension += sourceCRS.getCoordinateSystem().getDimension();
            }
            throw new DataStoreReferencingException(Resources.format((short)26, IdentifiedObjects.getName((IdentifiedObject)targetCRS, null)));
        }
    }

    public static enum Type {
        UNIVERSAL;

        static final int POLAR_THRESHOLD = 60;
    }
}

