/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.SetServerContextPathCommand;
import org.apache.sling.ide.eclipse.core.SetServerDebugPortCommand;
import org.apache.sling.ide.eclipse.core.SetServerPasswordCommand;
import org.apache.sling.ide.eclipse.core.SetServerPortCommand;
import org.apache.sling.ide.eclipse.core.SetServerUsernameCommand;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ConnectionEditorSection
extends ServerEditorSection {
    protected boolean _updating;
    protected PropertyChangeListener _listener;
    private Text portText;
    private Text debugPortText;
    private Text contextPathText;
    private Text usernameText;
    private Text passwordText;
    private ISlingLaunchpadServer launchpadServer;
    private PropertyChangeListener serverListener;
    private boolean updating = false;

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 456);
        section.setText("Connection");
        section.setDescription("Connection details for this server");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.createLabel(toolkit, composite, "Port:");
        this.portText = this.createText(toolkit, composite, 4);
        this.createLabel(toolkit, composite, "Debug Port:");
        this.debugPortText = this.createText(toolkit, composite, 4);
        this.createLabel(toolkit, composite, "Context path:");
        this.contextPathText = this.createText(toolkit, composite, 4);
        Label separator = toolkit.createSeparator(parent, 256);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        this.createLabel(toolkit, composite, "Username:");
        this.usernameText = this.createText(toolkit, composite, 4);
        this.createLabel(toolkit, composite, "Password:");
        this.passwordText = this.createText(toolkit, composite, 0x400000);
        this.initialize();
    }

    private void createLabel(FormToolkit toolkit, Composite composite, String label) {
        Label portLabel = toolkit.createLabel(composite, label);
        portLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
    }

    private Text createText(FormToolkit toolkit, Composite composite, int flags) {
        Text port = toolkit.createText(composite, "", flags);
        GridData data = new GridData(768);
        data.widthHint = 30;
        port.setLayoutData((Object)data);
        return port;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ConnectionEditorSection.this.updating) {
                    return;
                }
                ConnectionEditorSection.this.updating = true;
                try {
                    switch (evt.getPropertyName()) {
                        case "launchpad.port": {
                            ConnectionEditorSection.this.portText.setText(((Integer)evt.getNewValue()).toString());
                            break;
                        }
                        case "launchpad.debugPort": {
                            ConnectionEditorSection.this.debugPortText.setText(((Integer)evt.getNewValue()).toString());
                            break;
                        }
                        case "launchpad.contextPath": {
                            ConnectionEditorSection.this.contextPathText.setText((String)evt.getNewValue());
                            break;
                        }
                        case "launchpad.username": {
                            ConnectionEditorSection.this.usernameText.setText((String)evt.getNewValue());
                            break;
                        }
                        case "launchpad.password": {
                            ConnectionEditorSection.this.passwordText.setText((String)evt.getNewValue());
                        }
                    }
                }
                finally {
                    ConnectionEditorSection.this.updating = false;
                }
            }
        };
        this.server.addPropertyChangeListener(this.serverListener);
        this.launchpadServer = (ISlingLaunchpadServer)this.server.getAdapter(ISlingLaunchpadServer.class);
        if (this.launchpadServer == null) {
            this.launchpadServer = (ISlingLaunchpadServer)this.server.loadAdapter(ISlingLaunchpadServer.class, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void initialize() {
        ISlingLaunchpadConfiguration config = this.launchpadServer.getConfiguration();
        this.portText.setText(String.valueOf(config.getPort()));
        this.debugPortText.setText(String.valueOf(config.getDebugPort()));
        this.contextPathText.setText(config.getContextPath());
        this.usernameText.setText(config.getUsername());
        this.passwordText.setText(config.getPassword());
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConnectionEditorSection.this.updating) {
                    return;
                }
                ConnectionEditorSection.this.updating = true;
                try {
                    if (e.getSource() == ConnectionEditorSection.this.portText) {
                        try {
                            int port = Integer.parseInt(ConnectionEditorSection.this.portText.getText());
                            ConnectionEditorSection.this.execute((IUndoableOperation)new SetServerPortCommand(ConnectionEditorSection.this.server, port));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (e.getSource() == ConnectionEditorSection.this.debugPortText) {
                        try {
                            int debugPort = Integer.parseInt(ConnectionEditorSection.this.debugPortText.getText());
                            ConnectionEditorSection.this.execute((IUndoableOperation)new SetServerDebugPortCommand(ConnectionEditorSection.this.server, debugPort));
                        }
                        catch (NumberFormatException ex) {
                            ex.printStackTrace();
                        }
                    } else if (e.getSource() == ConnectionEditorSection.this.contextPathText) {
                        ConnectionEditorSection.this.execute((IUndoableOperation)new SetServerContextPathCommand(ConnectionEditorSection.this.server, ConnectionEditorSection.this.contextPathText.getText()));
                    } else if (e.getSource() == ConnectionEditorSection.this.usernameText) {
                        ConnectionEditorSection.this.execute((IUndoableOperation)new SetServerUsernameCommand(ConnectionEditorSection.this.server, ConnectionEditorSection.this.usernameText.getText()));
                    } else if (e.getSource() == ConnectionEditorSection.this.passwordText) {
                        ConnectionEditorSection.this.execute((IUndoableOperation)new SetServerPasswordCommand(ConnectionEditorSection.this.server, ConnectionEditorSection.this.passwordText.getText()));
                    }
                }
                finally {
                    ConnectionEditorSection.this.updating = false;
                }
            }
        };
        Text[] textArray = new Text[]{this.portText, this.debugPortText, this.contextPathText, this.usernameText, this.passwordText};
        int n = textArray.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            text.addModifyListener(listener);
            ++n2;
        }
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.serverListener);
        }
        super.dispose();
    }
}

