/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import jakarta.servlet.Filter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.engine.impl.filter.FilterPredicate;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;

public class FilterHandle
implements Comparable<FilterHandle> {
    private final Filter filter;
    private final long filterId;
    private final int order;
    private final String orderSource;
    private final AtomicLong calls;
    private final AtomicLong time;
    private final FilterPredicate predicate;
    private final FilterProcessorMBeanImpl mbean;

    FilterHandle(Filter filter, FilterPredicate predicate, long filterId, int order, String orderSource, FilterProcessorMBeanImpl mbean) {
        this.filter = filter;
        this.predicate = predicate;
        this.filterId = filterId;
        this.order = order;
        this.orderSource = orderSource;
        this.calls = new AtomicLong();
        this.time = new AtomicLong();
        this.mbean = mbean;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public long getFilterId() {
        return this.filterId;
    }

    public int getOrder() {
        return this.order;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    boolean select(SlingJakartaHttpServletRequest slingHttpServletRequest) {
        if (this.predicate != null) {
            return this.predicate.test(slingHttpServletRequest);
        }
        return true;
    }

    public long getCalls() {
        return this.calls.get();
    }

    public long getTime() {
        return this.time.get() / 1000L;
    }

    public long getTimePerCall() {
        return this.getCalls() > 0L ? this.time.get() / this.getCalls() : -1L;
    }

    void track() {
        this.calls.incrementAndGet();
    }

    void trackTime(long time) {
        this.time.addAndGet(time);
        if (this.mbean != null) {
            this.mbean.addFilterHandle(this);
        }
    }

    @Override
    public int compareTo(FilterHandle other) {
        if (this == other || this.equals(other)) {
            return 0;
        }
        if (this.order > other.order) {
            return -1;
        }
        if (this.order < other.order) {
            return 1;
        }
        return this.filterId < other.filterId ? -1 : (this.filterId == other.filterId ? 0 : 1);
    }

    public int hashCode() {
        if (this.filter == null) {
            return 0;
        }
        return this.filter.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilterHandle) {
            FilterHandle other = (FilterHandle)obj;
            return this.getFilter().equals(other.getFilter());
        }
        return false;
    }
}

