/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.inline;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.impl.ImageTransformation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

class InlineAutoCropping {
    private final Dimension imageDimension;
    private final MediaArgs mediaArgs;

    InlineAutoCropping(@NotNull Dimension imageDimension, @NotNull MediaArgs mediaArgs) {
        this.imageDimension = imageDimension;
        this.mediaArgs = mediaArgs;
    }

    public List<CropDimension> calculateAutoCropDimensions() {
        Stream<MediaFormat> mediaFormats = Arrays.stream((MediaFormat[])ObjectUtils.defaultIfNull((Object)this.mediaArgs.getMediaFormats(), (Object)new MediaFormat[0]));
        return mediaFormats.map(this::calculateAutoCropDimension).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private CropDimension calculateAutoCropDimension(@NotNull MediaFormat mediaFormat) {
        double ratio = mediaFormat.getRatio();
        if (ratio > 0.0 && this.imageDimension.getWidth() > 0L && this.imageDimension.getHeight() > 0L) {
            return ImageTransformation.calculateAutoCropDimension(this.imageDimension.getWidth(), this.imageDimension.getHeight(), ratio);
        }
        return null;
    }
}

