/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.peaberry.internal.ConcurrentReferenceHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComputedMapFactory {
    static final EnumSet<ConcurrentReferenceHashMap.Option> IDENTITY = EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS);

    private ComputedMapFactory() {
    }

    static <K, V> ConcurrentMap<K, V> computedMap(ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valType, int capacity, Function<K, V> function) {
        return new ComputedMap<K, V>(keyType, valType, capacity, function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComputedMap<K, V>
    extends ConcurrentReferenceHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final transient Function<K, V> function;

        public ComputedMap(ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valType, int capacity, Function<K, V> function) {
            super(capacity, 0.75f, 2, keyType, valType, IDENTITY);
            this.function = function;
        }

        @Override
        public V get(Object key) {
            V newValue;
            Object value = super.get(key);
            if (null == value && null == (value = this.putIfAbsent(key, newValue = this.function.compute(key)))) {
                return newValue;
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Function<K, V> {
        public V compute(K var1);
    }
}

