/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdResolver
implements ItemStateCreationListener,
EntryFactory.NodeEntryListener {
    private static Logger log = LoggerFactory.getLogger(UniqueIdResolver.class);
    private final ItemStateFactory isf;
    private final Map<String, NodeEntry> lookUp = new ReferenceMap(0, 1);

    public UniqueIdResolver(ItemStateFactory isf) {
        this.isf = isf;
        isf.addCreationListener(this);
    }

    public void dispose() {
        this.isf.removeCreationListener(this);
        this.lookUp.clear();
    }

    public NodeEntry lookup(String uniqueId) {
        if (uniqueId == null) {
            throw new IllegalArgumentException();
        }
        return this.lookUp.get(uniqueId);
    }

    public NodeEntry resolve(NodeId nodeId, NodeEntry rootEntry) throws ItemNotFoundException, RepositoryException {
        NodeEntry entry = this.lookup(nodeId.getUniqueID());
        if (entry == null) {
            NodeState state = this.isf.createDeepNodeState(nodeId, rootEntry);
            entry = state.getNodeEntry();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(ItemState state, int previousStatus) {
        Map<String, NodeEntry> map = this.lookUp;
        synchronized (map) {
            if (Status.isTerminal(state.getStatus())) {
                NodeEntry mapEntry;
                NodeEntry entry;
                String uniqueID;
                if (state.isNode() && (uniqueID = (entry = (NodeEntry)state.getHierarchyEntry()).getUniqueID()) != null && (mapEntry = this.lookUp.get(uniqueID)) == entry) {
                    this.lookUp.remove(uniqueID);
                }
                if (8 == state.getStatus()) {
                    state.removeListener(this);
                }
            }
        }
    }

    @Override
    public void created(ItemState state) {
        NodeEntry entry;
        String uniqueID;
        if (state.isNode() && (uniqueID = (entry = (NodeEntry)state.getHierarchyEntry()).getUniqueID()) != null && (!this.lookUp.containsKey(uniqueID) || this.lookUp.get(uniqueID) != entry)) {
            log.error("Created NodeState identified by UniqueID that is not contained in the lookup.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryCreated(NodeEntry entry) {
        Map<String, NodeEntry> map = this.lookUp;
        synchronized (map) {
            String uniqueID = entry.getUniqueID();
            if (uniqueID != null) {
                this.putToLookup(uniqueID, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uniqueIdChanged(NodeEntry entry, String previousUniqueID) {
        Map<String, NodeEntry> map = this.lookUp;
        synchronized (map) {
            String uniqueID;
            NodeEntry previous;
            if (previousUniqueID != null && (previous = this.lookUp.get(previousUniqueID)) == entry) {
                this.lookUp.remove(previousUniqueID);
            }
            if ((uniqueID = entry.getUniqueID()) != null) {
                this.putToLookup(uniqueID, entry);
            }
        }
    }

    private void putToLookup(String uniqueID, NodeEntry entry) {
        NodeEntry previous = this.lookUp.put(uniqueID, entry);
        if (previous != null) {
            if (!UniqueIdResolver.sameEntry(previous, entry)) {
                previous.remove();
            } else {
                log.debug("Replacement of NodeEntry identified by UniqueID");
            }
        }
    }

    private static boolean sameEntry(NodeEntry previous, NodeEntry entry) {
        if (previous == entry) {
            return true;
        }
        if (8 != previous.getStatus() && previous.getName().equals(entry.getName())) {
            NodeEntry parent2;
            NodeEntry parent = previous.getParent();
            if (parent == (parent2 = entry.getParent())) {
                return true;
            }
            try {
                return parent.getPath().equals(parent2.getPath());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }
}

