/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.text.MessageFormat;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.apache.sling.installer.core.impl.tasks.BundleInfo;
import org.apache.sling.installer.core.impl.tasks.BundleStartTask;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.RefreshBundlesTask;
import org.apache.sling.installer.core.impl.tasks.SystemBundleUpdateTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;

public class BundleUpdateTask
extends AbstractBundleTask {
    private static final String BUNDLE_UPDATE_ORDER = "50-";
    private static final int MAX_RETRIES = 5;
    private String ATTR_UPDATE_RETRY = "org.apache.sling.installer.core.impl.tasks.BundleUpdateTask.retrycount";

    public BundleUpdateTask(TaskResourceGroup r, TaskSupport creator) {
        super(r, creator);
    }

    private boolean isBundleActive(Bundle b) {
        if (BundleUtil.isBundleActive(b)) {
            return true;
        }
        BundleStartLevel startLevelService = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        return startLevelService.isPersistentlyStarted();
    }

    @Override
    public void execute(InstallationContext ctx) {
        String symbolicName = (String)this.getResource().getAttribute("Bundle-SymbolicName");
        Bundle b = BundleInfo.getMatchingBundle(this.getBundleContext(), symbolicName, null);
        if (b == null) {
            String message = MessageFormat.format("Bundle to update ({0}) not found", symbolicName);
            this.getLogger().debug(message);
            this.setFinishedState(ResourceState.IGNORED, null, message);
            return;
        }
        Version newVersion = new Version((String)this.getResource().getAttribute("Bundle-Version"));
        boolean snapshot = false;
        Version currentVersion = b.getVersion();
        snapshot = BundleInfo.isSnapshot(newVersion);
        BundleStartLevel startLevelService = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        int newStartLevel = this.getBundleStartLevel();
        int oldStartLevel = startLevelService.getStartLevel();
        if (currentVersion.equals((Object)newVersion) && !snapshot && newStartLevel == oldStartLevel) {
            String message = MessageFormat.format("Same version is already installed, and not a snapshot, ignoring update: {0}", this.getResource());
            this.getLogger().debug(message);
            this.setFinishedState(ResourceState.INSTALLED, null, message);
            return;
        }
        try {
            boolean reactivate = this.isBundleActive(b);
            int state = b.getState();
            if (state == 32 || state == 8) {
                b.stop();
            }
            b.update(this.getResource().getInputStream());
            ctx.log("Updated bundle {} from resource {}", b, this.getResource());
            BundleUpdateTask.setBundleLocation(this.getResource(), b.getLocation());
            if (newStartLevel != oldStartLevel && newStartLevel != 0) {
                startLevelService.setStartLevel(newStartLevel);
                ctx.log("Set start level for bundle {} to {}", b, newStartLevel);
            }
            if (reactivate) {
                if (BundleUtil.isSystemBundleFragment(b)) {
                    this.setFinishedState(ResourceState.INSTALLED);
                    ctx.addTaskToCurrentCycle(new SystemBundleUpdateTask(null, this.getTaskSupport()));
                } else if (BundleUtil.getFragmentHostHeader(b) != null) {
                    String fragmentHostHeader = BundleUtil.getFragmentHostHeader(b);
                    this.getLogger().debug("Need to do a refresh of the bundle's {} host", (Object)b);
                    for (Bundle bundle : this.getBundleContext().getBundles()) {
                        if (!fragmentHostHeader.equals(bundle.getSymbolicName())) continue;
                        this.getLogger().debug("Found host bundle for {} to refresh: {}", (Object)b, (Object)bundle);
                        RefreshBundlesTask.markBundleForRefresh(ctx, this.getTaskSupport(), bundle);
                        break;
                    }
                    this.setFinishedState(ResourceState.INSTALLED);
                } else {
                    BundleUtil.markBundleStart(this.getResource());
                    RefreshBundlesTask.markBundleForRefresh(ctx, this.getTaskSupport(), b);
                    ctx.addTaskToCurrentCycle(new BundleStartTask(this.getResourceGroup(), b.getBundleId(), this.getTaskSupport()));
                }
            } else {
                this.setFinishedState(ResourceState.INSTALLED);
            }
        }
        catch (Exception e) {
            int retries = 0;
            Object obj = this.getResource().getTemporaryAttribute(this.ATTR_UPDATE_RETRY);
            if (obj instanceof Integer) {
                retries = (Integer)obj;
            }
            this.getResource().setTemporaryAttribute(this.ATTR_UPDATE_RETRY, ++retries);
            if (retries > 5) {
                String message = MessageFormat.format("Removing failing update task due to {0} - unable to retry: {1}", e.getLocalizedMessage(), this);
                this.getLogger().error(message, (Throwable)e);
                this.setFinishedState(ResourceState.IGNORED, null, message);
            }
            String message = MessageFormat.format("Failing update task due to {0} - will retry up to {1} more time(s) for {2} later", e.getLocalizedMessage(), 5 - (retries - 1), this);
            this.getLogger().warn(message, (Throwable)e);
        }
    }

    @Override
    public String getSortKey() {
        return BUNDLE_UPDATE_ORDER + this.getSortableStartLevel() + "-" + this.getResource().getEntityId();
    }

    public Bundle getBundle() {
        String symbolicName = (String)this.getResource().getAttribute("Bundle-SymbolicName");
        return BundleInfo.getMatchingBundle(this.getBundleContext(), symbolicName, null);
    }
}

