/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;

public class MemorySegmentInputStreamWithPos
extends InputStream {
    private MemorySegment segment;
    private int position;
    private int count;
    private int mark;

    public MemorySegmentInputStreamWithPos(MemorySegment segment, int offset, int length) {
        this.setSegment(segment, offset, length);
    }

    @Override
    public int read() {
        return this.position < this.count ? 0xFF & this.segment.get(this.position++) : -1;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) {
        if (this.position >= this.count) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int numBytes = Math.min(this.count - this.position, len);
        this.segment.get(this.position, b, off, numBytes);
        this.position += numBytes;
        return numBytes;
    }

    @Override
    public long skip(long toSkip) {
        long remain = this.count - this.position;
        if (toSkip < remain) {
            remain = toSkip < 0L ? 0L : toSkip;
        }
        this.position = (int)((long)this.position + remain);
        return remain;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    @Override
    public int available() {
        return this.count - this.position;
    }

    @Override
    public void close() {
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int pos) {
        Preconditions.checkArgument(pos >= 0 && pos <= this.count, "Position out of bounds.");
        this.position = pos;
    }

    public void setSegment(MemorySegment segment, int offset, int length) {
        this.count = Math.min(segment.size(), offset + length);
        this.setPosition(offset);
        this.segment = segment;
        this.mark = offset;
    }
}

