/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class GenericTypeSerializerSnapshot<T, S extends TypeSerializer>
implements TypeSerializerSnapshot<T> {
    private static final int VERSION = 2;
    private Class<T> typeClass;

    protected GenericTypeSerializerSnapshot() {
    }

    protected GenericTypeSerializerSnapshot(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass, "type class can not be NULL");
    }

    protected abstract TypeSerializer<T> createSerializer(Class<T> var1);

    protected abstract Class<T> getTypeClass(S var1);

    protected abstract Class<?> serializerClass();

    @Override
    public final int getCurrentVersion() {
        return 2;
    }

    @Override
    public final void writeSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState(this.typeClass != null, "type class can not be NULL");
        out.writeUTF(this.typeClass.getName());
    }

    @Override
    public final void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.typeClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
    }

    @Override
    public final TypeSerializer<T> restoreSerializer() {
        Preconditions.checkState(this.typeClass != null, "type class can not be NULL");
        return this.createSerializer(this.typeClass);
    }

    @Override
    public final TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        if (!this.serializerClass().isInstance(newSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        TypeSerializer<T> casted = newSerializer;
        if (this.typeClass == this.getTypeClass(casted)) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }
}

