/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractCloseableRegistry<C extends Closeable, T>
implements Closeable {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    protected final Map<Closeable, T> closeableToRef;
    @GuardedBy(value="lock")
    private boolean closed;

    public AbstractCloseableRegistry(@Nonnull Map<Closeable, T> closeableToRef) {
        this.closeableToRef = Preconditions.checkNotNull(closeableToRef);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerCloseable(C closeable) throws IOException {
        if (null == closeable) {
            return;
        }
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (!this.closed) {
                this.doRegister(closeable, this.closeableToRef);
                return;
            }
        }
        IOUtils.closeQuietly(closeable);
        throw new IOException("Cannot register Closeable, registry is already closed. Closing argument.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregisterCloseable(C closeable) {
        if (null == closeable) {
            return false;
        }
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.doUnRegister(closeable, this.closeableToRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Collection<Closeable> toCloseCopy;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            toCloseCopy = this.getReferencesToClose();
            this.closeableToRef.clear();
        }
        IOUtils.closeAllQuietly(toCloseCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closed;
        }
    }

    protected Collection<Closeable> getReferencesToClose() {
        return new ArrayList<Closeable>(this.closeableToRef.keySet());
    }

    protected abstract void doRegister(@Nonnull C var1, @Nonnull Map<Closeable, T> var2);

    protected abstract boolean doUnRegister(@Nonnull C var1, @Nonnull Map<Closeable, T> var2);

    protected final Object getSynchronizationLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addCloseableInternal(Closeable closeable, T metaData) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            this.closeableToRef.put(closeable, metaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeCloseableInternal(Closeable closeable) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.remove(closeable) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int getNumberOfRegisteredCloseables() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean isCloseableRegistered(Closeable c) {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            return this.closeableToRef.containsKey(c);
        }
    }
}

