/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.startup;

import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.access.TilesAccess;
import org.apache.tiles.core.factory.AbstractTilesContainerFactory;
import org.apache.tiles.core.startup.TilesInitializer;
import org.apache.tiles.request.ApplicationAccess;
import org.apache.tiles.request.ApplicationContext;

public abstract class AbstractTilesInitializer
implements TilesInitializer {
    private ApplicationContext applicationContext;

    @Override
    public void initialize(ApplicationContext applicationContext) {
        this.applicationContext = this.createTilesApplicationContext(applicationContext);
        ApplicationAccess.register(applicationContext);
        String key = this.getContainerKey(this.applicationContext);
        TilesContainer container = this.createContainer(this.applicationContext);
        TilesAccess.setContainer(this.applicationContext, container, key);
    }

    @Override
    public void destroy() {
        TilesAccess.setContainer(this.applicationContext, null, this.getContainerKey(this.applicationContext));
    }

    protected ApplicationContext createTilesApplicationContext(ApplicationContext preliminaryContext) {
        return preliminaryContext;
    }

    protected String getContainerKey(ApplicationContext applicationContext) {
        return null;
    }

    protected TilesContainer createContainer(ApplicationContext context) {
        AbstractTilesContainerFactory factory = this.createContainerFactory(context);
        return factory.createContainer(context);
    }

    protected abstract AbstractTilesContainerFactory createContainerFactory(ApplicationContext var1);
}

