/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.GridCellSize;
import net.sf.jasperreports.engine.export.GridCellStyle;
import net.sf.jasperreports.engine.export.JRExporterGridCell;

public class ElementReplacementGridCell
extends JRExporterGridCell {
    private final ElementGridCell originalCell;
    private final JRPrintElement element;

    public ElementReplacementGridCell(ElementGridCell originalCell, JRPrintElement element) {
        super(originalCell.getStyle());
        this.originalCell = originalCell;
        this.element = element;
    }

    @Override
    public GridCellSize getSize() {
        return this.originalCell.getSize();
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public JRPrintElement getElement() {
        return this.element;
    }

    @Override
    public String getElementAddress() {
        return this.originalCell.getElementAddress();
    }

    @Override
    public String getProperty(String propName) {
        if (this.element.hasProperties() && this.element.getPropertiesMap().containsProperty(propName)) {
            return this.element.getPropertiesMap().getProperty(propName);
        }
        return this.originalCell.getProperty(propName);
    }

    @Override
    public void setBox(JRLineBox box) {
        GridCellStyle newStyle = this.originalCell.getContainer().cellStyle(this.getBackcolor(), this.getForecolor(), box);
        this.setStyle(newStyle);
    }
}

