#!/bin/bash
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

set -e
set -u

export VTA_HW_PATH=`pwd`

cd tvm

export LD_LIBRARY_PATH="lib:${LD_LIBRARY_PATH:-}"

# to avoid CI thread throttling.
export TVM_BIND_THREADS=0
export OMP_NUM_THREADS=1

# Build cpptest suite
make cpptest -j2

# "make crttest" requires USE_MICRO to be enabled, which is not always the case.
if grep crttest build/Makefile > /dev/null; then
    make crttest  # NOTE: don't parallelize, due to issue with build deps.
fi

cd build && ctest --gtest_death_test_style=threadsafe && cd ..
