/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class StringLength
extends SystemFunction {
    private boolean shortcut = false;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this.simplifyArguments(staticContext);
    }

    public int getIntrinsicDependencies() {
        int n = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            n |= 2;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(staticContext.makeEarlyEvaluationContext())));
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.argument.length == 0 && itemType == null) {
            StaticError staticError = new StaticError("The context item for string-length() is undefined");
            staticError.setErrorCode("XPDY0002");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        return super.typeCheck(staticContext, itemType);
    }

    public void setShortcut() {
        this.shortcut = true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        Object object;
        if (this.argument.length == 0) {
            object = xPathContext.getContextItem();
            if (object == null) {
                this.dynamicError("The context item for string-length() is not set", "XPDY0002", xPathContext);
            }
            atomicValue = StringValue.makeStringValue(object.getStringValueCS());
        } else {
            atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        }
        if (atomicValue == null) {
            return Int64Value.ZERO;
        }
        object = atomicValue.getStringValueCS();
        if (this.shortcut) {
            return object.length() > 0 ? Int64Value.PLUS_ONE : Int64Value.ZERO;
        }
        return Int64Value.makeIntegerValue(StringValue.getStringLength((CharSequence)object));
    }
}

